/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.parser.sparql;

public final class SPARQL {
    private SPARQL() {
        throw new AssertionError();
    }

    public static String encodeString(String s) {
        s = s.replace("\\", "\\\\");
        s = s.replace("\t", "\\t");
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\b", "\\b");
        s = s.replace("\f", "\\f");
        s = s.replace("\"", "\\\"");
        s = s.replace("'", "\\'");
        return s;
    }

    public static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\'') {
                sb.append('\'');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    public static enum CompareOp {
        EQ("="),
        NE("!="),
        GT(">"),
        GTE(">="),
        LT("<"),
        LTE("<=");

        private final String mSymbol;

        private CompareOp(String theSymbol) {
            this.mSymbol = theSymbol;
        }

        public String getSymbol() {
            return this.mSymbol;
        }
    }

    public static enum MathOp {
        Add("+"),
        Subtract("-"),
        Multiply("*"),
        Divide("/");

        private final String mSymbol;

        private MathOp(String theSymbol) {
            this.mSymbol = theSymbol;
        }

        public String getSymbol() {
            return this.mSymbol;
        }
    }
}

