/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.parser.sparql;

import com.complexible.common.rdf.query.parser.sparql.AbstractASTVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCustomAggregate;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIRI;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOperationContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPrefixDecl;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTQName;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.stardog.stark.query.MalformedQuery;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrefixDeclProcessor {
    public static Map<String, String> process(ASTOperationContainer qc, Map<String, String> thePrefixMap) throws MalformedQuery {
        List<ASTPrefixDecl> prefixDeclList = qc.getPrefixDeclList();
        LinkedHashMap<String, String> prefixMap = new LinkedHashMap<String, String>();
        for (ASTPrefixDecl aSTPrefixDecl : prefixDeclList) {
            String prefix = aSTPrefixDecl.getPrefix();
            String iri = aSTPrefixDecl.getIRI().getValue();
            if (prefixMap.containsKey(prefix)) {
                throw new MalformedQuery("Multiple prefix declarations for prefix '" + prefix + "'");
            }
            prefixMap.put(prefix, iri);
        }
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "owl", "http://www.w3.org/2002/07/owl#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "xsd", "http://www.w3.org/2001/XMLSchema#");
        PrefixDeclProcessor.insertDefaultPrefix(prefixMap, "fn", "http://www.w3.org/2005/xpath-functions#");
        for (Map.Entry entry : thePrefixMap.entrySet()) {
            PrefixDeclProcessor.insertDefaultPrefix(prefixMap, (String)entry.getKey(), (String)entry.getValue());
        }
        QNameProcessor visitor = new QNameProcessor(prefixMap);
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException visitorException) {
            throw new MalformedQuery((Throwable)visitorException);
        }
        return prefixMap;
    }

    private static void insertDefaultPrefix(Map<String, String> prefixMap, String prefix, String namespace) {
        if (!prefixMap.containsKey(prefix)) {
            prefixMap.put(prefix, namespace);
        }
    }

    private static String createPrefixesInSPARQLFormat(Map<String, String> prefixMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : prefixMap.entrySet()) {
            sb.append("PREFIX");
            String prefix = entry.getKey();
            if (prefix != null) {
                sb.append(" " + prefix);
            }
            sb.append(":");
            sb.append(" <" + entry.getValue() + "> \n");
        }
        return sb.toString();
    }

    private static class QNameProcessor
    extends AbstractASTVisitor {
        private Map<String, String> prefixMap;

        public QNameProcessor(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        @Override
        public Object visit(ASTQName qnameNode, Object data) throws VisitorException {
            String qname = qnameNode.getValue();
            int colonIdx = qname.indexOf(58);
            assert (colonIdx >= 0) : "colonIdx should be >= 0: " + colonIdx;
            String prefix = qname.substring(0, colonIdx);
            String localName = qname.substring(colonIdx + 1);
            String namespace = this.prefixMap.get(prefix);
            if (namespace == null) {
                throw new VisitorException("QName '" + qname + "' uses an undefined prefix");
            }
            localName = this.processEscapes(localName);
            ASTIRI iriNode = new ASTIRI(66);
            iriNode.setValue(namespace + localName);
            qnameNode.jjtReplaceWith(iriNode);
            return null;
        }

        @Override
        public Object visit(ASTCustomAggregate node, Object data) throws VisitorException {
            String name = node.getURI();
            int colonIdx = name.indexOf(58);
            if (colonIdx != -1) {
                String prefix = name.substring(0, colonIdx);
                String localName = name.substring(colonIdx + 1);
                String namespace = this.prefixMap.get(prefix);
                if (namespace == null) {
                    throw new VisitorException("Custom aggregate QName '" + name + "' uses an undefined prefix");
                }
                localName = this.processEscapes(localName);
                node.setURI(namespace + localName);
            }
            return null;
        }

        private String processEscapes(String localName) {
            StringBuffer unescaped = new StringBuffer();
            Pattern escapedCharPattern = Pattern.compile("\\\\[_~\\.\\-!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\/\\?#\\@\\%]");
            Matcher m = escapedCharPattern.matcher(localName);
            boolean result = m.find();
            while (result) {
                String escaped = m.group();
                m.appendReplacement(unescaped, escaped.substring(1));
                result = m.find();
            }
            m.appendTail(unescaped);
            return unescaped.toString();
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setPrefixDeclarations(this.prefixMap);
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTUnparsedQuadDataBlock node, Object data) {
            String prefixes = PrefixDeclProcessor.createPrefixesInSPARQLFormat(this.prefixMap);
            node.setDataBlock(prefixes + node.getDataBlock());
            return super.visit(node, data);
        }
    }
}

