/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.parser.sparql;

import com.complexible.common.io.block.BlockMarker;
import com.complexible.common.io.block.BlockSpec;
import com.complexible.common.io.block.BlockWriter;
import com.complexible.common.io.block.Bracket;
import com.complexible.common.io.block.TextBlockWriter;
import com.complexible.common.rdf.query.parser.sparql.AbstractASTVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTAbs;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTAdd;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTAggregate;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTAnd;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTAskQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTAvg;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBNodeFunc;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBaseDecl;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBind;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBindingSet;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBindingValue;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBindingsClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBlankNode;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBlankNodePropertyList;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTBound;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCeil;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTClear;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCoalesce;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCollection;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCompare;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTConcat;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTConstant;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTConstraint;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTConstruct;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTConstructQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTContains;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCopy;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCount;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCreate;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTCustomAggregate;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDatasetClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDatatype;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDay;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDeleteClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDeleteData;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDeleteWhere;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDescribe;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDescribeQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDrop;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTEncodeForURI;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTExistsFunc;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTFalse;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTFloor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTFunctionCall;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTFunctionDefinition;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTGraphGraphPattern;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTGraphOrDefault;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTGraphPatternGroup;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTGraphRefAll;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTGroupClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTGroupConcat;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTGroupCondition;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTHavingClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTHint;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTHours;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIRI;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIRIFunc;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIf;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIfClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIfThenQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIfThenQueryContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIn;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTInfix;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTInlineData;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTInsertClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTInsertData;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIsBlank;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIsIRI;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIsLiteral;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIsNumeric;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTLang;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTLangMatches;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTLimit;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTLoad;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTLowerCase;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMD5;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMath;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMax;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMaxLength;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMin;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMinusGraphPattern;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMinutes;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTModify;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMonth;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTMove;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTNot;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTNotExistsFunc;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTNotIn;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTNow;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTNumericLiteral;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTObjectList;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOffset;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOptionalGraphPattern;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOr;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOrderClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTOrderCondition;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathAlternative;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathElt;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathMod;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathNegatedPropertySet;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathOneInPropertySet;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathSequence;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathSpec;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPathTerminal;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPrefixDecl;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTProjectionElem;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPropertyList;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTPropertyListPath;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTQName;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTQuadsNotTriples;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTQueryContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTRDFLiteral;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTRand;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTRegexExpression;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTReplace;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSHA1;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSHA224;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSHA256;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSHA384;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSHA512;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSTRUUID;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSameTerm;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSample;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSeconds;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSelect;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSelectQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStr;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStrAfter;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStrBefore;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStrDt;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStrEnds;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStrLang;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStrLen;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTStrStarts;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTString;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSubstr;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSum;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTThenClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTTimezone;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTTriplesSameSubject;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTTriplesSameSubjectPath;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTTrue;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTTz;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUUID;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnionGraphPattern;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnnest;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUnprefixedFunctionName;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpdate;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpdateContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpdateSequence;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpperCase;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTVar;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTVia;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTWhereClause;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTYear;
import com.complexible.common.rdf.query.parser.sparql.ast.Node;
import com.complexible.common.rdf.query.parser.sparql.ast.SimpleNode;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.stardog.stark.vocabs.RDF;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class ASTSPARQLRenderer
extends AbstractASTVisitor {
    private final StringWriter mStringWriter = new StringWriter();
    private final BlockWriter mWriter = new TextBlockWriter((Writer)this.mStringWriter);
    private static final BlockSpec BLOCK = BlockSpec.INDENTED.copy().newLineAfterBegin(true).newLineAfterEnd(true).marker((BlockMarker)Bracket.CURLY);
    Predicate<Node> atomic = new Predicate<Node>(this){

        public boolean apply(Node node) {
            return node instanceof ASTIRI || node instanceof ASTQName || node instanceof ASTPathMod;
        }
    };

    public synchronized String render(Node node) {
        try {
            this.mStringWriter.getBuffer().setLength(0);
            node.jjtAccept(this, null);
            return this.mStringWriter.toString();
        }
        catch (VisitorException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object visitFunctionArgs(SimpleNode node, String data) throws VisitorException {
        this.mWriter.print(data);
        this.mWriter.print("(");
        if (node instanceof ASTAggregate && ((ASTAggregate)node).isDistinct()) {
            this.mWriter.print("DISTINCT");
        }
        Object o = this.visitChildren(node, null, ", ", false);
        this.mWriter.print(")");
        return o;
    }

    public Object visitNode(SimpleNode node, String data) throws VisitorException {
        if (node == null) {
            return null;
        }
        if (data != null) {
            this.mWriter.write(data);
        }
        return node.jjtAccept(this, null);
    }

    public Object visitChildrenBlock(SimpleNode node, String data) throws VisitorException {
        return this.visitBlock(node, data, false);
    }

    public Object visitNodeBlock(SimpleNode node, String data) throws VisitorException {
        return this.visitBlock(node, data, true);
    }

    public Object visitBlock(SimpleNode node, String data, boolean visitNode) throws VisitorException {
        if (node != null) {
            if (data != null) {
                this.mWriter.print(data);
            }
            this.mWriter.beginBlock(BLOCK);
            Object o = visitNode ? node.jjtAccept(this, null) : this.visitChildren(node, null, false);
            this.mWriter.endBlock();
            return o;
        }
        return null;
    }

    public Object visitChildren(SimpleNode node, Object data, boolean newline) throws VisitorException {
        return this.visitChildren(node, data, 0, "", newline);
    }

    public Object visitChildren(SimpleNode node, Object data, String sep, boolean newline) throws VisitorException {
        return this.visitChildren(node, data, 0, sep, newline);
    }

    public Object visitChildren(SimpleNode node, Object data, int start, String sep, boolean newline) throws VisitorException {
        return this.visitChildren(node, data, start, sep, newline, (Predicate<? super Node>)Predicates.alwaysFalse());
    }

    public Object visitChildren(SimpleNode node, Object data, int start, String sep, boolean newline, Predicate<? super Node> requiresParen) throws VisitorException {
        if (node == null) {
            return null;
        }
        if (data != null) {
            this.mWriter.print(data);
        }
        int n = node.jjtGetNumChildren();
        for (int i = start; i < n; ++i) {
            Node childNode;
            boolean paren;
            if (i > start) {
                this.mWriter.print(sep);
            }
            if (paren = requiresParen.apply((Object)(childNode = node.jjtGetChild(i)))) {
                this.mWriter.print("(");
            }
            data = childNode.jjtAccept(this, null);
            if (!paren) continue;
            this.mWriter.print(")");
        }
        if (newline) {
            this.mWriter.println();
        }
        return data;
    }

    @Override
    public Object visit(ASTAbs node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "abs");
    }

    @Override
    public Object visit(ASTUpdateSequence node, Object data) throws VisitorException {
        return this.visitChildren(node, data, ";\n", true);
    }

    @Override
    public Object visit(ASTBindingValue node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() == 0) {
            this.mWriter.print("UNDEF");
        }
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTInlineData node, Object data) throws VisitorException {
        return this.visitValues(node, data);
    }

    @Override
    public Object visit(ASTUpdateContainer node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTAdd node, Object data) throws VisitorException {
        this.mWriter.print("ADD ");
        if (node.isSilent()) {
            this.mWriter.print("SILENT ");
        }
        return this.visitChildren(node, data, " TO ", true);
    }

    @Override
    public Object visit(ASTBindingSet node, Object data) throws VisitorException {
        this.mWriter.print("(");
        Object o = this.visitChildren(node, data, " ", false);
        this.mWriter.println(")");
        return o;
    }

    @Override
    public Object visit(ASTClear node, Object data) throws VisitorException {
        this.mWriter.print("CLEAR ");
        if (node.isSilent()) {
            this.mWriter.print("SILENT ");
        }
        return this.visitChildren(node, data, true);
    }

    @Override
    public Object visit(ASTCopy node, Object data) throws VisitorException {
        this.mWriter.print("COPY ");
        if (node.isSilent()) {
            this.mWriter.print("SILENT ");
        }
        return this.visitChildren(node, data, " TO ", true);
    }

    @Override
    public Object visit(ASTCreate node, Object data) throws VisitorException {
        this.mWriter.print("CREATE ");
        if (node.isSilent()) {
            this.mWriter.print("SILENT ");
        }
        this.mWriter.print("GRAPH ");
        return this.visitChildren(node, data, true);
    }

    @Override
    public Object visit(ASTDeleteClause node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "DELETE ");
    }

    @Override
    public Object visit(ASTDeleteData node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "DELETE DATA ");
    }

    @Override
    public Object visit(ASTDeleteWhere node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "DELETE WHERE ");
    }

    @Override
    public Object visit(ASTDrop node, Object data) throws VisitorException {
        this.mWriter.print("DROP ");
        if (node.isSilent()) {
            this.mWriter.print("SILENT ");
        }
        return this.visitChildren(node, data, true);
    }

    @Override
    public Object visit(ASTGraphOrDefault node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() == 0) {
            this.mWriter.print("DEFAULT ");
        }
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTUnparsedQuadDataBlock node, Object data) throws VisitorException {
        this.mWriter.write(node.getDataBlock());
        return null;
    }

    @Override
    public Object visit(ASTGraphRefAll node, Object data) throws VisitorException {
        this.mWriter.print(node.isDefault() ? "DEFAULT " : (node.isNamed() ? "NAMED " : (node.jjtGetNumChildren() == 0 ? "ALL " : "GRAPH ")));
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTInfix node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTInsertClause node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "INSERT ");
    }

    @Override
    public Object visit(ASTInsertData node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "INSERT DATA ");
    }

    @Override
    public Object visit(ASTLoad node, Object data) throws VisitorException {
        this.mWriter.print("LOAD ");
        if (node.isSilent()) {
            this.mWriter.print("SILENT ");
        }
        return this.visitChildren(node, data, " INTO GRAPH ", true);
    }

    @Override
    public Object visit(ASTModify node, Object data) throws VisitorException {
        this.visitNode(node.jjtGetChild(ASTIRI.class), "WITH ");
        this.visitNode(node.jjtGetChild(ASTQName.class), "WITH ");
        this.mWriter.println();
        this.visitNode(node.getDeleteClause(), null);
        this.visitNode(node.getInsertClause(), null);
        return this.visitNode(node.getWhereClause(), "WHERE ");
    }

    @Override
    public Object visit(ASTMove node, Object data) throws VisitorException {
        this.mWriter.print("MOVE ");
        if (node.isSilent()) {
            this.mWriter.print("SILENT ");
        }
        return this.visitChildren(node, data, " TO ", true);
    }

    @Override
    public Object visit(ASTNow node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "now");
    }

    @Override
    public Object visit(ASTYear node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "year");
    }

    @Override
    public Object visit(ASTMonth node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "month");
    }

    @Override
    public Object visit(ASTDay node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "day");
    }

    @Override
    public Object visit(ASTHours node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "hours");
    }

    @Override
    public Object visit(ASTTz node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "tz");
    }

    @Override
    public Object visit(ASTMinutes node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "minutes");
    }

    @Override
    public Object visit(ASTSeconds node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "seconds");
    }

    @Override
    public Object visit(ASTTimezone node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "timezone");
    }

    @Override
    public Object visit(ASTAnd node, Object data) throws VisitorException {
        return this.visitChildren(node, data, 0, " && ", false, (Predicate<? super Node>)Predicates.instanceOf(ASTOr.class));
    }

    @Override
    public Object visit(ASTAskQuery node, Object data) throws VisitorException {
        this.mWriter.print("ASK ");
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTAvg node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "avg");
    }

    @Override
    public Object visit(ASTMD5 node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "MD5");
    }

    @Override
    public Object visit(ASTSHA1 node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "SHA1");
    }

    @Override
    public Object visit(ASTSHA224 node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "SHA224");
    }

    @Override
    public Object visit(ASTSHA256 node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "SHA256");
    }

    @Override
    public Object visit(ASTSHA384 node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "SHA384");
    }

    @Override
    public Object visit(ASTSHA512 node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "SHA512");
    }

    @Override
    public Object visit(ASTBaseDecl node, Object data) throws VisitorException {
        this.mWriter.print("BASE <");
        this.mWriter.print(node.getIRI());
        this.mWriter.println(">");
        return this.visitChildren(node, null, false);
    }

    @Override
    public Object visit(ASTBind node, Object data) throws VisitorException {
        this.mWriter.print("BIND(");
        Object o = this.visitChildren(node, data, " AS ", false);
        this.mWriter.println(")");
        return o;
    }

    @Override
    public Object visit(ASTUnnest node, Object data) throws VisitorException {
        this.mWriter.print("UNNEST(");
        Object o = this.visitChildren(node, data, " AS ", false);
        this.mWriter.println(")");
        return o;
    }

    @Override
    public Object visit(ASTBindingsClause node, Object data) throws VisitorException {
        return this.visitValues(node, data);
    }

    public Object visitValues(SimpleNode node, Object data) throws VisitorException {
        this.mWriter.print("VALUES (");
        boolean first = true;
        for (Node node2 : node.jjtGetChildren(ASTVar.class)) {
            if (first) {
                first = false;
            } else {
                this.mWriter.print(" ");
            }
            node2.jjtAccept(this, data);
        }
        this.mWriter.print(") ");
        this.mWriter.beginBlock(BLOCK);
        for (Node node3 : node.jjtGetChildren(ASTBindingSet.class)) {
            if (first) {
                first = false;
            } else {
                this.mWriter.print(" ");
            }
            data = node3.jjtAccept(this, data);
        }
        this.mWriter.endBlock();
        return data;
    }

    @Override
    public Object visit(ASTBlankNode node, Object data) throws VisitorException {
        if (node.getID() == null) {
            this.mWriter.write("[]");
        } else {
            this.mWriter.write("_:");
            this.mWriter.write(node.getID());
        }
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
        this.mWriter.print("[");
        Object o = this.visitChildren(node, data, false);
        this.mWriter.print("]");
        return o;
    }

    @Override
    public Object visit(ASTBNodeFunc node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "bnode");
    }

    @Override
    public Object visit(ASTBound node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "bound");
    }

    @Override
    public Object visit(ASTCeil node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "ceil");
    }

    @Override
    public Object visit(ASTCoalesce node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "coalesce");
    }

    @Override
    public Object visit(ASTConcat node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "concat");
    }

    @Override
    public Object visit(ASTContains node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "contains");
    }

    @Override
    public Object visit(ASTCollection node, Object data) throws VisitorException {
        this.mWriter.print("(");
        Object o = this.visitChildren(node, data, " ", false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTCompare node, Object data) throws VisitorException {
        return this.visitChildren(node, data, node.getOperator().getSymbol(), false);
    }

    @Override
    public Object visit(ASTConstraint node, Object data) throws VisitorException {
        boolean regular;
        boolean havingClause = node.jjtGetParent() instanceof ASTHavingClause;
        this.mWriter.print(havingClause ? "HAVING " : "FILTER ");
        boolean notExists = node.jjtGetChild(0) instanceof ASTNotExistsFunc;
        boolean exists = node.jjtGetChild(0) instanceof ASTExistsFunc;
        boolean bl = regular = !exists || !notExists;
        if (regular) {
            this.mWriter.print("(");
        }
        Object o = this.visitChildren(node, data, " ", false);
        if (regular) {
            this.mWriter.println(")");
        }
        return o;
    }

    @Override
    public Object visit(ASTConstruct node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "CONSTRUCT ");
    }

    @Override
    public Object visit(ASTConstructQuery node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTCount node, Object data) throws VisitorException {
        this.mWriter.print("count(");
        if (node.isDistinct()) {
            this.mWriter.print("distinct ");
        }
        if (node.isWildcard()) {
            this.mWriter.print("*");
        }
        Object o = this.visitChildren(node, data, false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTCustomAggregate node, Object data) throws VisitorException {
        this.mWriter.print("agg:" + node.getURI() + " (");
        if (node.isDistinct()) {
            this.mWriter.print("distinct ");
        }
        Object o = this.visitChildren(node, data, false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTDatasetClause node, Object data) throws VisitorException {
        this.mWriter.print("FROM ");
        if (node.isNamed()) {
            this.mWriter.print("NAMED ");
        }
        return this.visitChildren(node, data, " ", true);
    }

    @Override
    public Object visit(ASTDatatype node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "datatype");
    }

    @Override
    public Object visit(ASTDescribe node, Object data) throws VisitorException {
        this.mWriter.print("DESCRIBE ");
        return this.visitChildren(node, data, " ", true);
    }

    @Override
    public Object visit(ASTDescribeQuery node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTExistsFunc node, Object data) throws VisitorException {
        this.mWriter.print("EXISTS ");
        Object o = this.visitChildren(node, data, false);
        return o;
    }

    @Override
    public Object visit(ASTEncodeForURI node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "encode_for_uri");
    }

    @Override
    public Object visit(ASTFalse node, Object data) throws VisitorException {
        this.mWriter.print("false");
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTFloor node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "floor");
    }

    @Override
    public Object visit(ASTFunctionCall node, Object data) throws VisitorException {
        node.jjtGetChild(0).jjtAccept(this, data);
        this.mWriter.print("(");
        Object o = this.visitChildren(node, data, 1, ",", false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTGraphGraphPattern node, Object data) throws VisitorException {
        this.mWriter.print("GRAPH ");
        node.jjtGetChild(0).jjtAccept(this, data);
        this.mWriter.print(" ");
        this.mWriter.beginBlock(BLOCK);
        Object o = node.jjtGetChild(1).jjtAccept(this, data);
        this.mWriter.endBlock();
        return o;
    }

    @Override
    public Object visit(ASTGraphPatternGroup node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "");
    }

    @Override
    public Object visit(ASTGroupClause node, Object data) throws VisitorException {
        this.mWriter.print("GROUP BY ");
        return this.visitChildren(node, data, " ", true);
    }

    @Override
    public Object visit(ASTGroupConcat node, Object data) throws VisitorException {
        Object o = this.visitChildren(node, "group_concat(", "; separator=", false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTGroupCondition node, Object data) throws VisitorException {
        this.mWriter.print("(");
        Object o = this.visitChildren(node, data, " AS ", false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTHavingClause node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTIf node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "IF");
    }

    @Override
    public Object visit(ASTIn node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, " IN ");
    }

    @Override
    public Object visit(ASTIRI node, Object data) throws VisitorException {
        if (node.getValue().equals(RDF.TYPE.toString())) {
            this.mWriter.print("a");
        } else {
            this.mWriter.print("<");
            this.mWriter.print(node.getValue());
            this.mWriter.print(">");
        }
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTIRIFunc node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "iri");
    }

    @Override
    public Object visit(ASTIsBlank node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "isBlank");
    }

    @Override
    public Object visit(ASTIsIRI node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "isIRI");
    }

    @Override
    public Object visit(ASTIsLiteral node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "isLiteral");
    }

    @Override
    public Object visit(ASTIsNumeric node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "isNumeric");
    }

    @Override
    public Object visit(ASTLang node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "lang");
    }

    @Override
    public Object visit(ASTLangMatches node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "langMatches");
    }

    @Override
    public Object visit(ASTLimit node, Object data) throws VisitorException {
        this.mWriter.print("LIMIT ");
        this.mWriter.println(node.getValue());
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTLowerCase node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "lcase");
    }

    @Override
    public Object visit(ASTMath node, Object data) throws VisitorException {
        this.mWriter.print("(");
        Object o = this.visitChildren(node, data, " " + node.getOperator().getSymbol() + " ", false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTMax node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "max");
    }

    @Override
    public Object visit(ASTMin node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "min");
    }

    @Override
    public Object visit(ASTMinusGraphPattern node, Object data) throws VisitorException {
        this.mWriter.print("MINUS ");
        return this.visitChildren(node, null, false);
    }

    @Override
    public Object visit(ASTNot node, Object data) throws VisitorException {
        this.mWriter.print("!");
        return this.visitChildren(node, data, 0, "", false, (Predicate<? super Node>)Predicates.or((Predicate)Predicates.instanceOf(ASTOr.class), (Predicate)Predicates.instanceOf(ASTAnd.class)));
    }

    @Override
    public Object visit(ASTNotExistsFunc node, Object data) throws VisitorException {
        this.mWriter.print("NOT EXISTS ");
        Object o = this.visitChildren(node, data, false);
        return o;
    }

    @Override
    public Object visit(ASTNotIn node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, " NOT IN ");
    }

    @Override
    public Object visit(ASTNumericLiteral node, Object data) throws VisitorException {
        String num = node.getValue();
        this.mWriter.print(num);
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTObjectList node, Object data) throws VisitorException {
        return this.visitChildren(node, data, " , ", false);
    }

    @Override
    public Object visit(ASTOffset node, Object data) throws VisitorException {
        this.mWriter.print("OFFSET ");
        this.mWriter.println(node.getValue());
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTOptionalGraphPattern node, Object data) throws VisitorException {
        return this.visitChildrenBlock(node, "OPTIONAL ");
    }

    @Override
    public Object visit(ASTOr node, Object data) throws VisitorException {
        return this.visitChildren(node, data, 0, " || ", false, (Predicate<? super Node>)Predicates.instanceOf(ASTAnd.class));
    }

    @Override
    public Object visit(ASTOrderClause node, Object data) throws VisitorException {
        this.mWriter.print("ORDER BY ");
        return this.visitChildren(node, data, " ", true);
    }

    @Override
    public Object visit(ASTOrderCondition node, Object data) throws VisitorException {
        boolean needsParen;
        boolean bl = needsParen = node.isAscending() && node.jjtGetChildren(ASTVar.class).size() != node.jjtGetNumChildren();
        if (!node.isAscending()) {
            this.mWriter.print("DESC(");
        } else if (needsParen) {
            this.mWriter.print("(");
        }
        Object o = this.visitChildren(node, data, false);
        if (!node.isAscending() || needsParen) {
            this.mWriter.print(")");
        }
        return o;
    }

    @Override
    public Object visit(ASTPathAlternative node, Object data) throws VisitorException {
        return this.visitChildren(node, data, "|", false);
    }

    @Override
    public Object visit(ASTPathElt node, Object data) throws VisitorException {
        if (node.isInverse()) {
            this.mWriter.print("^");
        }
        return this.visitChildren(node, data, 0, "", false, (Predicate<? super Node>)Predicates.not(this.atomic));
    }

    @Override
    public Object visit(ASTPathMod node, Object data) throws VisitorException {
        this.mWriter.print(node.getLowerBound() == 0L ? (node.getUpperBound() == 1L ? "?" : "*") : "+");
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTPathNegatedPropertySet node, Object data) throws VisitorException {
        this.mWriter.print("!(");
        Object o = this.visitChildren(node, data, 0, "|", false);
        this.mWriter.print(")");
        return o;
    }

    @Override
    public Object visit(ASTPathOneInPropertySet node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTPathSequence node, Object data) throws VisitorException {
        return this.visitChildren(node, data, "/", false);
    }

    @Override
    public Object visit(ASTPrefixDecl node, Object data) throws VisitorException {
        this.mWriter.print("PREFIX ");
        this.mWriter.print(node.getPrefix());
        this.mWriter.print(": ");
        return this.visitChildren(node, data, true);
    }

    @Override
    public Object visit(ASTProjectionElem node, Object data) throws VisitorException {
        if (node.hasAlias()) {
            this.mWriter.print("(");
        }
        Object o = this.visitChildren(node, data, " AS ", false);
        if (node.hasAlias()) {
            this.mWriter.print(")");
        }
        return o;
    }

    @Override
    public Object visit(ASTPropertyList node, Object data) throws VisitorException {
        node.getVerb().jjtAccept(this, data);
        this.mWriter.print(" ");
        node.getObjectList().jjtAccept(this, data);
        ASTPropertyList next = node.getNextPropertyList();
        if (next != null) {
            this.mWriter.println(" ;");
            next.jjtAccept(this, data);
        }
        return null;
    }

    @Override
    public Object visit(ASTPropertyListPath node, Object data) throws VisitorException {
        node.getVerb().jjtAccept(this, data);
        this.mWriter.print(" ");
        node.getObjectList().jjtAccept(this, data);
        ASTPropertyListPath next = node.getNextPropertyList();
        if (next != null) {
            this.mWriter.println(" ;");
            next.jjtAccept(this, data);
        }
        return null;
    }

    @Override
    public Object visit(ASTQName node, Object data) throws VisitorException {
        this.mWriter.print(node.getValue());
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTQueryContainer node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTRand node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "rand");
    }

    @Override
    public Object visit(ASTRDFLiteral node, Object data) throws VisitorException {
        Object o = this.visitChildren(node, data, "^^", false);
        if (!Strings.isNullOrEmpty((String)node.getLang())) {
            this.mWriter.print("@");
            this.mWriter.append((CharSequence)node.getLang());
        }
        return o;
    }

    @Override
    public Object visit(ASTRegexExpression node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "regex");
    }

    @Override
    public Object visit(ASTReplace node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "replace");
    }

    @Override
    public Object visit(ASTSameTerm node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTSample node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "sample");
    }

    @Override
    public Object visit(ASTSelect node, Object data) throws VisitorException {
        this.mWriter.append((CharSequence)"SELECT ");
        if (node.isDistinct()) {
            this.mWriter.append((CharSequence)"DISTINCT ");
        } else if (node.isReduced()) {
            this.mWriter.append((CharSequence)"REDUCED ");
        }
        if (node.isWildcard()) {
            this.mWriter.append((CharSequence)"*");
        }
        Object o = this.visitChildren(node, data, " ", false);
        this.mWriter.println();
        return o;
    }

    @Override
    public Object visit(ASTPathQuery node, Object data) throws VisitorException {
        List<ASTPathTerminal> aTerminals = node.jjtGetChildren(ASTPathTerminal.class);
        node.jjtGetChild(0).jjtAccept(this, data);
        ASTDatasetClause aDataset = node.jjtGetChild(ASTDatasetClause.class);
        if (aDataset != null) {
            aDataset.jjtAccept(this, data);
        }
        this.mWriter.append((CharSequence)"START ");
        aTerminals.get(0).jjtAccept(this, data);
        this.mWriter.append((CharSequence)" END ");
        aTerminals.get(1).jjtAccept(this, data);
        node.jjtGetChild(ASTVia.class).jjtAccept(this, data);
        ASTMaxLength aMaxLength = node.jjtGetChild(ASTMaxLength.class);
        if (aMaxLength != null) {
            aMaxLength.jjtAccept(this, data);
        }
        return null;
    }

    @Override
    public Object visit(ASTVia node, Object data) throws VisitorException {
        this.mWriter.append((CharSequence)" VIA ");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTPathTerminal node, Object data) throws VisitorException {
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() > 1) {
            Node aTerminal = node.jjtGetChild(1);
            if (aTerminal instanceof ASTConstant) {
                this.mWriter.append((CharSequence)" = ");
                aTerminal.jjtAccept(this, data);
            } else {
                aTerminal.jjtAccept(this, data);
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTMaxLength node, Object data) throws VisitorException {
        this.mWriter.append((CharSequence)"MAX LENGTH ").append(String.valueOf(node.getValue())).append(' ');
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTPathSpec node, Object data) throws VisitorException {
        this.mWriter.append((CharSequence)"PATHS ");
        if (!node.isShortest()) {
            this.mWriter.append((CharSequence)"ALL ");
        }
        if (node.isCyclic()) {
            this.mWriter.append((CharSequence)"CYCLIC ");
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTSelectQuery node, Object data) throws VisitorException {
        boolean needsBlock;
        boolean bl = needsBlock = !(node.jjtGetParent() instanceof ASTQueryContainer);
        if (needsBlock) {
            this.mWriter.beginBlock(BLOCK);
        }
        Object o = this.visitChildren(node, data, false);
        if (needsBlock) {
            this.mWriter.endBlock();
        }
        return o;
    }

    @Override
    public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
        Object clause = "SERVICE ";
        if (node.isSilent()) {
            clause = (String)clause + "SILENT ";
        }
        return this.visitChildren(node, clause, " ", false);
    }

    @Override
    public Object visit(ASTStr node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "str");
    }

    @Override
    public Object visit(ASTStrAfter node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "strafter");
    }

    @Override
    public Object visit(ASTStrBefore node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "strbefore");
    }

    @Override
    public Object visit(ASTStrDt node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "strdt");
    }

    @Override
    public Object visit(ASTStrEnds node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "strends");
    }

    @Override
    public Object visit(ASTString node, Object data) throws VisitorException {
        String label = node.getValue();
        String delim = label.indexOf(10) > 0 || label.indexOf(13) > 0 || label.indexOf(9) > 0 ? "\"\"\"" : "\"";
        label = label.replace("\\\"", "\"");
        label = label.replace("\"", "\\\"");
        this.mWriter.print(delim);
        this.mWriter.write(label);
        this.mWriter.print(delim);
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTUUID node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "uuid");
    }

    @Override
    public Object visit(ASTSTRUUID node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "struuid");
    }

    @Override
    public Object visit(ASTStrLang node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "strlang");
    }

    @Override
    public Object visit(ASTStrLen node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "strlen");
    }

    @Override
    public Object visit(ASTStrStarts node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "strstarts");
    }

    @Override
    public Object visit(ASTSubstr node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "substr");
    }

    @Override
    public Object visit(ASTSum node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "sum");
    }

    @Override
    public Object visit(ASTTriplesSameSubject node, Object data) throws VisitorException {
        return this.appendTriples(node, data);
    }

    @Override
    public Object visit(ASTTriplesSameSubjectPath node, Object data) throws VisitorException {
        return this.appendTriples(node, data);
    }

    public Object appendTriples(SimpleNode node, Object data) throws VisitorException {
        Object o = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() > 1) {
            this.mWriter.print(" ");
            this.mWriter.beginBlock();
            o = node.jjtGetChild(1).jjtAccept(this, data);
            this.mWriter.println(" .");
            this.mWriter.endBlock();
        } else {
            this.mWriter.println();
        }
        return o;
    }

    @Override
    public Object visit(ASTQuadsNotTriples node, Object data) throws VisitorException {
        this.mWriter.print("GRAPH ");
        node.jjtGetChild(0).jjtAccept(this, data);
        this.mWriter.print(" ");
        this.mWriter.beginBlock(BLOCK);
        Object o = node.jjtGetChild(1).jjtAccept(this, data);
        this.mWriter.endBlock();
        return o;
    }

    @Override
    public Object visit(ASTTrue node, Object data) throws VisitorException {
        this.mWriter.print("true");
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTUnionGraphPattern node, Object data) throws VisitorException {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.mWriter.println("UNION");
            }
            this.mWriter.beginBlock(BLOCK);
            Node childNode = node.jjtGetChild(i);
            data = childNode.jjtAccept(this, data);
            this.mWriter.endBlock();
        }
        return data;
    }

    public Object visit(ASTUpdate node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTUpperCase node, Object data) throws VisitorException {
        return this.visitFunctionArgs(node, "ucase");
    }

    @Override
    public Object visit(ASTVar node, Object data) throws VisitorException {
        this.mWriter.print('?');
        this.mWriter.print(node.getName());
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTWhereClause node, Object data) throws VisitorException {
        this.mWriter.print("WHERE ");
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(SimpleNode node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTIfThenQueryContainer node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTIfThenQuery node, Object data) throws VisitorException {
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTIfClause node, Object data) throws VisitorException {
        this.mWriter.print("IF ");
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTThenClause node, Object data) throws VisitorException {
        boolean needsBlock;
        this.mWriter.print("THEN ");
        boolean bl = needsBlock = !(node.jjtGetParent() instanceof ASTQueryContainer);
        if (needsBlock) {
            this.mWriter.beginBlock(BLOCK);
        }
        Object o = this.visitChildren(node, data, false);
        if (needsBlock) {
            this.mWriter.endBlock();
        }
        return o;
    }

    @Override
    public Object visit(ASTUnprefixedFunctionName node, Object data) throws VisitorException {
        this.mWriter.print(node.getFunctionName());
        return this.visitChildren(node, data, false);
    }

    @Override
    public Object visit(ASTFunctionDefinition node, Object data) throws VisitorException {
        this.mWriter.print("FUNCTION ");
        node.jjtGetChild(0).jjtAccept(this, data);
        this.mWriter.print(" ");
        this.mWriter.beginBlock(BLOCK);
        Object o = this.visitChildren(node, data, 1, ";", true);
        this.mWriter.endBlock();
        return o;
    }

    @Override
    public Object visit(ASTHint node, Object data) throws VisitorException {
        this.mWriter.append(' ');
        this.mWriter.append((CharSequence)"#pragma ");
        this.mWriter.append((CharSequence)node.getKey());
        this.mWriter.append(' ');
        this.mWriter.append((CharSequence)node.getValue()).println();
        return super.visit(node, data);
    }
}

