/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.CloseableIterator;
import com.google.common.collect.AbstractIterator;
import com.stardog.stark.query.QueryExecutionFailure;
import java.util.function.Function;

public abstract class IteratorAsQueryResult<T>
extends AbstractIterator<T>
implements CloseableIterator<T> {
    final CloseableIterator<T> mIter;
    private boolean mClosed = false;
    final Runnable mOnClose;
    final Runnable mOnSuccess;
    final Function<Exception, RuntimeException> mOnError;
    boolean mConsumed = false;

    public IteratorAsQueryResult(CloseableIterator<T> theIter, Runnable theOnClose, Runnable theOnSuccess) {
        this(theIter, theOnClose, theOnSuccess, err -> {
            if (err instanceof QueryExecutionFailure) {
                return (QueryExecutionFailure)err;
            }
            return new QueryExecutionFailure((Throwable)err);
        });
    }

    public IteratorAsQueryResult(CloseableIterator<T> theIter, Runnable theOnClose, Runnable theOnSuccess, Function<Exception, RuntimeException> theOnError) {
        this.mIter = theIter;
        this.mOnClose = theOnClose;
        this.mOnSuccess = theOnSuccess;
        this.mOnError = theOnError;
    }

    public void close() throws QueryExecutionFailure {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        try {
            if (!this.mConsumed) {
                this.mOnSuccess.run();
            }
        }
        catch (Exception e) {
            try {
                throw new QueryExecutionFailure((Throwable)e);
            }
            catch (Throwable throwable) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
                autoCloseableArray[0] = this.mIter;
                autoCloseableArray[1] = this.mOnClose::run;
                AutoCloser.close((AutoCloseable[])autoCloseableArray);
                throw throwable;
            }
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this.mIter;
        autoCloseableArray[1] = this.mOnClose::run;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    protected T computeNext() {
        try {
            if (this.mIter.hasNext()) {
                return (T)this.mIter.next();
            }
            this.mConsumed = true;
            this.mOnSuccess.run();
            return (T)this.endOfData();
        }
        catch (Exception e) {
            this.mConsumed = true;
            throw this.mOnError.apply(e);
        }
    }
}

