/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Disposables;
import com.complexible.common.rdf.query.BindingSetIterator;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.PeekingIterator;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Service;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.QueryResultHandler;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultHandlerException;
import com.stardog.stark.query.io.QueryResultParsers;
import com.stardog.stark.query.io.SelectQueryResultParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOBindingSetIterator
extends AbstractIterator<BindingSet>
implements BindingSetIterator,
PeekingIterator<BindingSet>,
CloseableIterator<BindingSet> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOBindingSetIterator.class);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final ArrayBlockingQueue<BindingSet> mBindingSetQueue = new ArrayBlockingQueue(1000);
    private final ParseService mParseService;
    private Exception mError;
    private static final BindingSet EOS = BindingSets.builder().build();
    private final AtomicBoolean seenEndFlag = new AtomicBoolean(false);
    private final AtomicReference<List<String>> mBindingNames = new AtomicReference();

    public IOBindingSetIterator(InputStream theStream, QueryResultFormat theFormat) {
        this.mParseService = new ParseService(theStream, theFormat);
        this.mBindingNames.set(Collections.emptyList());
        Disposables.markCreated((Object)this);
    }

    protected BindingSet computeNext() {
        if (this.done.get()) {
            this.seenEndFlag.set(true);
            return (BindingSet)this.endOfData();
        }
        if (!this.mParseService.isRunning() && this.mParseService.state() == Service.State.NEW) {
            this.mParseService.startAsync();
        }
        try {
            BindingSet aBindingSet = this.mBindingSetQueue.take();
            if (this.mError != null) {
                this.seenEndFlag.set(true);
                Throwables.propagateIfInstanceOf((Throwable)this.mError, RuntimeException.class);
                throw new UncheckedIOException(new IOException(this.mError));
            }
            if (aBindingSet == EOS) {
                this.seenEndFlag.set(true);
                return (BindingSet)this.endOfData();
            }
            return aBindingSet;
        }
        catch (InterruptedException e) {
            this.seenEndFlag.set(true);
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public void close() {
        Disposables.markReleased((Object)this);
        this.seenEndFlag.set(true);
        this.mParseService.stopAsync();
        this.mParseService.awaitTerminated();
    }

    @Override
    public List<String> variables() {
        return this.mBindingNames.get();
    }

    private void sendEndOfStream() {
        try {
            if (this.seenEndFlag.get()) {
                return;
            }
            this.mBindingSetQueue.put(EOS);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
    }

    private class ParseService
    extends AbstractExecutionThreadService {
        private final InputStream mStream;
        private final QueryResultFormat mFormat;

        private ParseService(InputStream theStream, QueryResultFormat theFormat) {
            this.mStream = theStream;
            this.mFormat = theFormat;
        }

        protected String serviceName() {
            return "Stardog.IOBindingSetIteration.ParseService";
        }

        protected void run() throws Exception {
            SelectQueryResultParser aParser = (SelectQueryResultParser)QueryResultParsers.forSelectFormat((QueryResultFormat)this.mFormat).get();
            try {
                aParser.parse(this.mStream, (QueryResultHandler)new QueueingTupleQueryResultHandler());
            }
            catch (Exception e) {
                IOBindingSetIterator.this.sendEndOfStream();
                IOBindingSetIterator.this.mError = e;
            }
        }

        protected void triggerShutdown() {
            IOBindingSetIterator.this.mBindingSetQueue.clear();
            IOBindingSetIterator.this.done.set(true);
            try {
                this.mStream.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close input stream from binding set iteration: {}", (Object)e.getMessage());
            }
        }
    }

    private class QueueingTupleQueryResultHandler
    implements SelectQueryResultHandler {
        private QueueingTupleQueryResultHandler() {
        }

        public void handle(@Nonnull BindingSet theBindingSet) {
            if (IOBindingSetIterator.this.done.get()) {
                IOBindingSetIterator.this.sendEndOfStream();
                throw new QueryResultHandlerException("Closed");
            }
            try {
                IOBindingSetIterator.this.mBindingSetQueue.put(theBindingSet);
            }
            catch (InterruptedException e) {
                IOBindingSetIterator.this.sendEndOfStream();
                throw new QueryResultHandlerException((Throwable)e);
            }
        }

        public void variables(@Nonnull List<String> theNames) {
            IOBindingSetIterator.this.mBindingNames.set(theNames);
        }

        public void end() {
            IOBindingSetIterator.this.sendEndOfStream();
        }

        public void links(@Nonnull List<String> theList) {
        }

        public void start() {
        }
    }
}

