/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query;

import com.complexible.common.base.Disposables;
import com.complexible.common.rdf.StatementIterator;
import com.google.common.collect.AbstractIterator;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.query.GraphQueryResult;

public final class GraphQueryResultIterator
extends AbstractIterator<Statement>
implements StatementIterator {
    private final GraphQueryResult mResult;
    private final Resource mContext;
    private NamespacesImpl mNamespaces = null;

    public GraphQueryResultIterator(GraphQueryResult theResult) {
        this(theResult, null);
    }

    public GraphQueryResultIterator(GraphQueryResult theResult, Resource theContext) {
        this.mResult = theResult;
        this.mContext = theContext;
        Disposables.markCreated((Object)this);
    }

    @Override
    public Namespaces namespaces() {
        if (this.mNamespaces == null) {
            this.mNamespaces = new NamespacesImpl();
            this.mResult.namespaces().forEach(arg_0 -> ((NamespacesImpl)this.mNamespaces).add(arg_0));
        }
        return this.mNamespaces;
    }

    public Statement computeNext() {
        if (this.mResult.hasNext()) {
            Statement aStmt = (Statement)this.mResult.next();
            if (this.mContext == null) {
                return aStmt;
            }
            return Values.statement((Resource)aStmt.subject(), (IRI)aStmt.predicate(), (Value)aStmt.object(), (Resource)this.mContext);
        }
        return (Statement)this.endOfData();
    }

    public void close() {
        Disposables.markReleased((Object)this);
        this.mResult.close();
    }
}

