/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.RDFFileSupplier;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.StreamStatementIterator;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.google.common.base.Throwables;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamStatementSource
implements RDFFileSupplier,
StatementSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamStatementSource.class);
    private final Future<Path> mFile;
    private final Resource mContext;
    private final RDFFormat mFormat;
    private final boolean mDeleteFileOnClose;
    private final Options mParserConfig;

    public StreamStatementSource(RDFFormat theFormat, Options theParserConfig, Future<Path> theFile, Resource theContext, boolean theDeleteFileOnClose) throws IOException {
        this.mContext = theContext;
        this.mFile = theFile;
        this.mFormat = theFormat;
        this.mDeleteFileOnClose = theDeleteFileOnClose;
        this.mParserConfig = theParserConfig;
    }

    @Override
    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.get(), new OpenOption[0]);
    }

    @Override
    public RDFFormat format() {
        return this.mFormat;
    }

    @Override
    public Resource getContext() {
        return this.mContext;
    }

    @Override
    public Options getParserConfig() {
        return this.mParserConfig;
    }

    @Override
    public StatementIterator statements() {
        try {
            return new StreamStatementIterator(RDFStreams.forFile(this.mFile.get()).format(this.mFormat).config(this.mParserConfig).context(this.mContext).build());
        }
        catch (InterruptedException e) {
            throw new UncheckedIOException(new IOException(e));
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), RuntimeException.class);
            throw new UncheckedIOException(e.getCause() instanceof IOException ? (IOException)e.getCause() : new IOException(e.getCause()));
        }
    }

    @Override
    public List<RDFStream> streams() {
        try {
            return RDFStreams.forFile(this.mFile.get()).format(this.mFormat).config(this.mParserConfig).context(this.mContext).build();
        }
        catch (InterruptedException e) {
            throw new UncheckedIOException(new IOException(e));
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), RuntimeException.class);
            throw new UncheckedIOException(e.getCause() instanceof IOException ? (IOException)e.getCause() : new IOException(e.getCause()));
        }
    }

    @Override
    public void close() {
        if (!this.mFile.isDone()) {
            this.mFile.cancel(false);
        }
        try {
            Path aFile = this.get();
            if (this.mDeleteFileOnClose) {
                try {
                    Files.deleteIfExists(aFile);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to delete temporary file {}", (Object)aFile, (Object)e);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Path get() throws IOException {
        try {
            return this.mFile.get();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IOException(e.getCause());
        }
    }

    @Override
    public long estimatedCount() {
        try {
            return RDFStreams.estimatedCount(Files.size(this.get()), this.mFormat);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

