/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.base.Disposables;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreamProcessor;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.impl.ImmutableNamespaces;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamStatementIterator
extends AbstractIterator<Statement>
implements StatementIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamStatementIterator.class);
    private final StatementIterator mIter;

    public StreamStatementIterator(RDFStream theStream) {
        this((List<RDFStream>)ImmutableList.of((Object)theStream));
    }

    public StreamStatementIterator(List<RDFStream> theStreams) {
        this.mIter = RDFStreamProcessor.iteration(theStreams);
        Disposables.markCreated((Object)this);
    }

    @Override
    public Namespaces namespaces() {
        try {
            return this.mIter.namespaces();
        }
        catch (Throwable e) {
            LOGGER.warn("Error getting namespaces", e);
            return ImmutableNamespaces.empty();
        }
    }

    protected Statement computeNext() {
        try {
            return this.mIter.hasNext() ? (Statement)this.mIter.next() : (Statement)this.endOfData();
        }
        catch (Throwable e) {
            Throwables.propagateIfPossible((Throwable)e, UncheckedIOException.class);
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public void close() {
        Disposables.markReleased((Object)this);
        try {
            this.mIter.close();
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to close input stream from parsing: {}", (Object)(e.getMessage() != null ? e.getMessage() : e.toString()), (Object)e);
        }
    }
}

