/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.rdf.StatementIterator;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.stardog.stark.Statement;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public final class StatementIterationInputStream
extends InputStream {
    private StatementIterator mResult;
    private RDFWriter mWriter;
    private ByteBuffer mByteBuffer;
    private boolean needsStart = true;
    private boolean needsEnd = true;
    private OutputStreamWriter mOutWriter;

    public StatementIterationInputStream(StatementIterator theResult) {
        this(theResult, RDFFormats.TRIG);
    }

    public StatementIterationInputStream(StatementIterator theResult, RDFFormat theFormat) {
        this.mResult = theResult;
        this.mByteBuffer = new ByteBuffer();
        this.mOutWriter = new OutputStreamWriter((OutputStream)this.mByteBuffer, Charsets.UTF_8);
        this.mWriter = (RDFWriter)RDFWriters.to((OutputStream)this.mByteBuffer, (RDFFormat)theFormat).get();
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.needsStart) {
                this.needsStart = false;
                this.mWriter.start();
                this.mResult.namespaces().forEach(ns -> this.mWriter.namespace(ns.prefix(), ns.iri()));
            }
            while (!this.mByteBuffer.canRead()) {
                if (this.mResult.hasNext()) {
                    this.mByteBuffer.reset();
                    this.mWriter.handle((Statement)this.mResult.next());
                    this.mOutWriter.flush();
                    continue;
                }
                if (this.needsEnd) {
                    this.needsEnd = false;
                    this.mByteBuffer.reset();
                    this.mWriter.end();
                    this.mOutWriter.flush();
                    if (this.mByteBuffer.canRead()) continue;
                    return -1;
                }
                return -1;
            }
            return this.mByteBuffer.read();
        }
        catch (Throwable e) {
            Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mByteBuffer.close();
        try {
            this.mResult.close();
        }
        catch (Throwable e) {
            Throwables.propagateIfInstanceOf((Throwable)e, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IOException(e);
        }
    }

    private static class ByteBuffer
    extends ByteArrayOutputStream {
        private int mReadIndex = 0;

        private ByteBuffer() {
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.mReadIndex = 0;
        }

        public boolean canRead() {
            return this.mReadIndex < this.count;
        }

        public byte read() {
            return this.buf[this.mReadIndex++];
        }
    }
}

