/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.RDFFileSupplier;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.StatementIterators;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.google.common.base.Preconditions;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public final class RDFFileReference
implements RDFFileSupplier,
StatementSource {
    private final Path mFile;
    private final RDFFormat mFormat;
    private final Resource mContext;
    private final Options mParserConfig;

    RDFFileReference(Path theFile, RDFFormat theFormat, Resource theContext, Options theParserConfig) {
        Preconditions.checkNotNull((Object)theFile);
        Preconditions.checkNotNull((Object)theParserConfig);
        this.mFile = theFile.toAbsolutePath();
        this.mFormat = theFormat;
        this.mContext = theContext;
        this.mParserConfig = theParserConfig;
    }

    @Override
    public Path get() {
        return this.mFile;
    }

    @Override
    public Resource getContext() {
        return this.mContext;
    }

    @Override
    public RDFFormat format() {
        return this.mFormat;
    }

    @Override
    public Options getParserConfig() {
        return this.mParserConfig;
    }

    @Override
    public StatementIterator statements() {
        return StatementIterators.create(this.streams());
    }

    @Override
    public List<RDFStream> streams() {
        return RDFStreams.forFile(this.mFile).format(this.mFormat).config(this.mParserConfig).context(this.mContext).build();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.mFile, new OpenOption[0]);
    }

    @Override
    public long estimatedCount() {
        try {
            return RDFStreams.estimatedCount(Files.size(this.mFile), this.mFormat);
        }
        catch (IOException ignored) {
            return -1L;
        }
    }
}

