/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.RDFStreamSupplier;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.StreamStatementIterator;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

final class OneTimeStreamStatementSource
implements RDFStreamSupplier,
StatementSource {
    private final Resource mContext;
    private final InputStream mStream;
    private final RDFFormat mFormat;
    private final Options mParserConfig;

    public OneTimeStreamStatementSource(RDFFormat theFormat, InputStream theStream, Options theParserConfig, Resource theContext) {
        this.mContext = theContext;
        this.mStream = theStream;
        this.mFormat = theFormat;
        this.mParserConfig = theParserConfig;
    }

    @Override
    public StatementIterator statements() {
        return new StreamStatementIterator(this.streams());
    }

    @Override
    public RDFFormat format() {
        return this.mFormat;
    }

    @Override
    public Options getParserConfig() {
        return this.mParserConfig;
    }

    @Override
    public Resource getContext() {
        return this.mContext;
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }

    @Override
    public InputStream openStream() {
        return this.mStream;
    }

    @Override
    public List<RDFStream> streams() {
        return RDFStreams.forStream(this.mStream).format(this.mFormat).config(this.mParserConfig).context(this.mContext).build();
    }
}

