/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.impl;

import com.complexible.common.rdf.DelegatingStatementSource;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.DefaultStatementIterator;
import com.complexible.common.rdf.rio.RDFStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class FilteredStatementSource
extends DelegatingStatementSource {
    protected final Predicate<Statement> mFilter;

    public FilteredStatementSource(StatementSource theSource, Predicate<Statement> theStmtSrcFilter) {
        super(theSource);
        this.mFilter = theStmtSrcFilter;
    }

    @Override
    public StatementIterator statements() {
        return new DefaultStatementIterator((Iterator<Statement>)Iterators.filter((Iterator)((Object)super.statements()), this.mFilter::test));
    }

    @Override
    public Resource getContext() {
        return this.getSource().getContext();
    }

    @Override
    public List<RDFStream> streams() {
        ImmutableList.Builder aBuilder = ImmutableList.builder();
        for (RDFStream aStream : super.streams()) {
            aBuilder.add((Object)new FilteredRDFStream(aStream, this.mFilter));
        }
        return aBuilder.build();
    }

    public int hashCode() {
        return Objects.hash(this.mFilter, this.getSource());
    }

    public boolean equals(Object theOther) {
        if (theOther instanceof FilteredStatementSource) {
            FilteredStatementSource aFilteredStmtSrc = (FilteredStatementSource)theOther;
            return Objects.equals(aFilteredStmtSrc.mFilter, this.mFilter) && Objects.equals(aFilteredStmtSrc.getSource(), this.getSource());
        }
        return false;
    }

    private static final class FilteredRDFStream
    implements RDFStream {
        private final RDFStream mStream;
        private final Predicate<Statement> mFilter;

        public FilteredRDFStream(RDFStream theStream, Predicate<Statement> theFilter) {
            this.mStream = theStream;
            this.mFilter = theFilter;
        }

        @Override
        public long bytesRead() {
            return this.mStream.bytesRead();
        }

        @Override
        public void parse(RDFHandler theHandler) throws IOException, InvalidRDF, RDFHandlerException {
            this.mStream.parse(new FilteredRDFHandler(theHandler, this.mFilter));
        }

        @Override
        public Resource getContext() {
            return this.mStream.getContext();
        }

        @Override
        public boolean hasContext() {
            return this.mStream.hasContext();
        }

        @Override
        public String getName() {
            return this.mStream.getName();
        }

        @Override
        public long length() {
            return this.mStream.length();
        }

        @Override
        public long estimatedCount() {
            return this.mStream.estimatedCount();
        }

        @Override
        public void close() throws IOException {
            this.mStream.close();
        }
    }

    private static final class FilteredRDFHandler
    implements RDFHandler {
        private final RDFHandler mHandler;
        private final Predicate<Statement> mFilter;

        public FilteredRDFHandler(RDFHandler theHandler, Predicate<Statement> theFilter) {
            this.mHandler = theHandler;
            this.mFilter = theFilter;
        }

        public void end() throws RDFHandlerException {
            this.mHandler.end();
        }

        public void start() throws RDFHandlerException {
            this.mHandler.start();
        }

        public void namespace(@Nonnull String thePrefix, @Nonnull String theURI) throws RDFHandlerException {
            this.mHandler.namespace(thePrefix, theURI);
        }

        public void handle(@Nonnull Statement theStmt) throws RDFHandlerException {
            if (this.mFilter.test(theStmt)) {
                this.mHandler.handle(theStmt);
            }
        }
    }
}

