/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.ProgressReporter;
import com.complexible.common.collect.ArrayIterable;
import com.complexible.common.rdf.ConcatStatementSource;
import com.complexible.common.rdf.ContextCopyStatementSourceImpl;
import com.complexible.common.rdf.ContextFallbackStatementSource;
import com.complexible.common.rdf.ContextOverrideStatementSource;
import com.complexible.common.rdf.DelegatingStatementSource;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.AbstractStatementSource;
import com.complexible.common.rdf.impl.FilteredStatementSource;
import com.complexible.common.rdf.impl.StatementIterators;
import com.complexible.common.rdf.impl.StreamStatementIterator;
import com.complexible.common.rdf.rio.RDFObfuscator;
import com.complexible.common.rdf.rio.RDFStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatementSources {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementSources.class);
    private static final StatementSource EMPTY = new EmptyStatementSource();

    private StatementSources() {
        throw new AssertionError();
    }

    public static void closeQuietly(StatementSource theSource) {
        try {
            if (theSource != null) {
                theSource.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("There was an error closing a statement source.", (Throwable)e);
        }
    }

    public static StatementSource empty() {
        return EMPTY;
    }

    public static StatementSource concat(Iterable<StatementSource> theSource) {
        return new ConcatStatementSource((List<StatementSource>)ImmutableList.copyOf(theSource));
    }

    public static StatementSource concat(StatementSource theSource, StatementSource theOther, StatementSource ... theRest) {
        return new ConcatStatementSource(Lists.newArrayList((Iterable)Iterables.concat((Iterable)Lists.newArrayList((Object[])new StatementSource[]{theSource, theOther}), (Iterable)new ArrayIterable((Object[])theRest))));
    }

    public static StatementSource copyContext(StatementSource theSrc, Resource theSourceContext, Resource theTargetContext) {
        return new ContextCopyStatementSourceImpl(theSrc, theSourceContext, theTargetContext);
    }

    public static StatementSource usingContext(StatementSource theSrc, Resource theContext) {
        return new ContextOverrideStatementSource(theSrc, theContext);
    }

    public static StatementSource withFallbackContext(StatementSource theSrc, Resource theContext) {
        if (theSrc.getContext() != null) {
            return theSrc;
        }
        return new ContextFallbackStatementSource(theSrc, theContext);
    }

    public static Set<Statement> toModel(StatementSource theSrc) throws IOException {
        HashSet<Statement> hashSet;
        block9: {
            HashSet<Statement> aGraph = new HashSet<Statement>();
            StatementIterator aIter = theSrc.statements();
            try {
                while (aIter.hasNext()) {
                    aGraph.add((Statement)aIter.next());
                }
                hashSet = aGraph;
                if (aIter == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (aIter != null) {
                        try {
                            aIter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            aIter.close();
        }
        return hashSet;
    }

    public static long size(StatementSource theSrc) throws IOException {
        long l;
        StatementIterator aIter = null;
        try {
            long aSize = 0L;
            aIter = theSrc.statements();
            while (aIter.hasNext()) {
                aIter.next();
                ++aSize;
            }
            l = aSize;
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{aIter});
                throw throwable;
            }
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{aIter});
        return l;
    }

    public static long write(StatementSource theSource, RDFFormat theFormat, OutputStream theOutputStream, ProgressReporter theReporter) throws IOException {
        return StatementSources.write(theSource, (RDFWriter)RDFWriters.to((OutputStream)theOutputStream, (RDFFormat)theFormat).get(), theReporter);
    }

    public static long write(StatementSource theSource, RDFWriter theWriter, ProgressReporter theReporter) throws IOException {
        return StatementSources.write(theSource, Optional.empty(), theWriter, theReporter);
    }

    public static long write(StatementSource theSource, Optional<Iterable<Namespace>> theNamespaces, RDFWriter theWriter, ProgressReporter theReporter) throws IOException {
        long l;
        StatementIterator aIter = theSource.statements();
        long aSize = theSource.estimatedCount();
        long aInterval = Long.MAX_VALUE;
        ProgressReporter aReporter = ProgressReporter.SILENT;
        if (aSize != -1L) {
            aInterval = 1024L;
            aReporter = theReporter;
            aReporter.incrementMaxProgress(aSize);
        }
        try {
            long aCount = 0L;
            theWriter.start();
            Iterable<Namespace> aNamespaces = theNamespaces.orElse((Iterable<Namespace>)aIter.namespaces());
            for (Namespace aNamespace : aNamespaces) {
                theWriter.namespace(aNamespace.prefix(), aNamespace.iri());
            }
            while (aIter.hasNext()) {
                if ((aCount++ & aInterval - 1L) == 0L) {
                    aReporter.increment(aInterval);
                }
                theWriter.handle((Statement)aIter.next());
            }
            theWriter.end();
            aReporter.increment(aCount % aInterval);
            l = aCount;
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{aIter});
                throw throwable;
            }
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{aIter});
        return l;
    }

    public static StatementSource filter(StatementSource theSource, Predicate<Statement> theFilter) {
        return new FilteredStatementSource(theSource, theFilter);
    }

    public static StatementSource obfuscated(StatementSource theSource, RDFObfuscator theObfuscator) {
        return new ObfuscatedStatementSource(theSource, theObfuscator);
    }

    public static StatementSource virtual(StatementSource theSource) {
        return new DelegatingStatementSource(theSource){

            @Override
            public boolean containsVirtual() {
                return true;
            }
        };
    }

    private static final class ObfuscatedStatementSource
    extends AbstractStatementSource {
        private final StatementSource mSource;
        private final RDFObfuscator mObfuscator;

        private ObfuscatedStatementSource(StatementSource theSource, RDFObfuscator theObfuscator) {
            this.mSource = theSource;
            this.mObfuscator = theObfuscator;
        }

        @Override
        public StatementIterator statements() {
            return StatementIterators.withNamespaces(StatementIterators.transform(this.mSource.statements(), this.mObfuscator), this.mObfuscator.namespaces());
        }

        @Override
        public long estimatedCount() {
            return this.mSource.estimatedCount();
        }
    }

    private static final class EmptyStatementSource
    extends AbstractStatementSource {
        private EmptyStatementSource() {
        }

        @Override
        public StatementIterator statements() {
            return StatementIterators.empty();
        }

        @Override
        public long estimatedCount() {
            return 0L;
        }
    }

    public static class RDFStreamStatementSource
    implements StatementSource {
        private final RDFStream mRdfStream;
        private final Closeable mCloseable;

        public RDFStreamStatementSource(RDFStream rdfStream) {
            this.mRdfStream = rdfStream;
            this.mCloseable = () -> {};
        }

        public RDFStreamStatementSource(RDFStream rdfStream, Closeable closeable) {
            this.mRdfStream = rdfStream;
            this.mCloseable = closeable;
        }

        @Override
        public StatementIterator statements() {
            return new StreamStatementIterator(this.streams());
        }

        @Override
        public Resource getContext() {
            return null;
        }

        @Override
        public List<RDFStream> streams() {
            return Collections.singletonList(this.mRdfStream);
        }

        @Override
        public void close() throws IOException {
            this.mCloseable.close();
        }

        @Override
        public long estimatedCount() {
            return this.mRdfStream.estimatedCount();
        }
    }
}

