/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf;

import com.complexible.common.rdf.MultiStatementIterator;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.StreamStatementIterator;
import com.complexible.common.rdf.impl.StreamStatementSource;
import com.complexible.common.rdf.rio.RDFStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.stardog.stark.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class ConcatStatementSource
implements StatementSource {
    private final ImmutableList<StatementSource> mSources;

    public ConcatStatementSource(List<StatementSource> theSources) {
        this.mSources = ImmutableList.copyOf(theSources);
    }

    public Iterator<StatementSource> sources() {
        return this.mSources.iterator();
    }

    @Override
    public void close() throws IOException {
        StringBuilder aBuilder = new StringBuilder();
        boolean aExceptionThrown = false;
        for (StatementSource aSrc : this.mSources) {
            try {
                aSrc.close();
            }
            catch (Exception e) {
                aExceptionThrown = true;
                aBuilder.append(e.getMessage()).append("\n");
            }
        }
        if (aExceptionThrown) {
            throw new IOException("Multiple exceptions were thrown, messages were: " + aBuilder.toString().trim());
        }
    }

    @Override
    public StatementIterator statements() {
        ArrayList aIterList = Lists.newArrayListWithExpectedSize((int)this.mSources.size());
        ArrayList aStreams = Lists.newArrayListWithExpectedSize((int)this.mSources.size());
        for (StatementSource aSrc : this.mSources) {
            if (aSrc instanceof StreamStatementSource) {
                aStreams.addAll(aSrc.streams());
                continue;
            }
            aIterList.add(aSrc.statements());
        }
        if (!aStreams.isEmpty()) {
            StreamStatementIterator aStreamIter = new StreamStatementIterator(aStreams);
            if (aIterList.isEmpty()) {
                return aStreamIter;
            }
            aIterList.add(aStreamIter);
        }
        return new MultiStatementIterator(aIterList);
    }

    @Override
    public Resource getContext() {
        return null;
    }

    @Override
    public List<RDFStream> streams() {
        ArrayList aStreams = Lists.newArrayList();
        for (StatementSource aSource : this.mSources) {
            aStreams.addAll(aSource.streams());
        }
        return aStreams;
    }

    @Override
    public long estimatedCount() {
        return this.mSources.stream().mapToLong(StatementSource::estimatedCount).sum();
    }

    @Override
    public boolean containsVirtual() {
        return this.mSources.stream().anyMatch(StatementSource::containsVirtual);
    }

    @Override
    public boolean inMemory() {
        return Iterables.all(this.mSources, StatementSource::inMemory);
    }
}

