/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql.cli;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.io.Files2;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.graphql.GraphQLConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.complexible.stardog.graphql.GraphQLSchemaManager;
import com.complexible.stardog.graphql.GraphQLSchemas;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import graphql.schema.GraphQLSchema;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

@Command(name="schema", description="List, get, add or remove GraphQL schemas. The default action is listing existing schemas.", examples={"* Lists the existing GraphQL schemas in a database", "    $ stardog graphql schema --list myDb", "", "* Adds the GraphQL schema to the database", "    $ stardog graphql schema --add starwars myDb starwars.graphqls", "", "* Prints the GraphQL schema with given name", "    $ stardog graphql schema --show starwars myDb", "", "* Remove the GraphQL schema with given name from the database", "    $ stardog graphql schema --remove starwars myDb"})
public final class GraphQLSchemaCmd
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The subsequent argument is the GraphQL schema file if --add option is used.", title={"database", "schemaFile"})
    public final List<String> mArgs = Lists.newArrayList();
    protected String mDbName;
    protected File mSchemaFile;
    @Option(name={"-a", "--add"}, title="schemaName", description="Adds a new GraphQL schema.")
    protected String mAddSchema = null;
    @Option(name={"-s", "--show"}, title="schemaName", description="Prints the GraphQL schema with the given name.")
    protected String mGetSchema = null;
    @Option(name={"-r", "--remove"}, title="schemaName", description="Removes a GraphQL schema from this database. Use '*' to remove all schemas.")
    protected String mRemoveSchema = null;
    @Option(name={"-l", "--list"}, description="Lists the names of all GraphQL schemas in this database", arity=0)
    public boolean isList = false;

    @Inject
    public GraphQLSchemaCmd(PasswordReader theReader) {
        super(theReader);
    }

    public void execute(Connection theConn) throws StardogException {
        this.validateCommands();
        try {
            GraphQLSchemaManager aMgr = ((GraphQLConnection)theConn.as(GraphQLConnection.class)).schemas();
            if (this.mAddSchema != null) {
                aMgr.addSchema(this.mAddSchema, GraphQLSchemas.read((String)Files2.toString((Path)this.mSchemaFile.toPath(), (Charset)Charsets.UTF_8)));
                System.out.println(GraphQLSchemaCmd.get((String)"graphql.schema.added", (Object[])new Object[]{this.mAddSchema}));
            } else if (this.mRemoveSchema != null) {
                if (this.mRemoveSchema.equals("*")) {
                    aMgr.clearSchemas();
                    System.out.println(GraphQLSchemaCmd.get((String)"graphql.schema.removed.all", (Object[])new Object[]{this.mRemoveSchema}));
                } else {
                    aMgr.removeSchema(this.mRemoveSchema);
                    System.out.println(GraphQLSchemaCmd.get((String)"graphql.schema.removed", (Object[])new Object[]{this.mRemoveSchema}));
                }
            } else if (this.mGetSchema != null) {
                System.out.println(GraphQLSchemas.write((GraphQLSchema)aMgr.getSchema(this.mGetSchema)));
            } else {
                ImmutableList aSchemas = Ordering.usingToString().immutableSortedCopy(aMgr.getSchemas());
                if (aSchemas.isEmpty()) {
                    System.out.println(GraphQLSchemaCmd.get((String)"graphql.no.schemas", (Object[])new Object[0]));
                } else {
                    TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, new String[]{"Schemas"});
                    for (String aDatabase : aSchemas) {
                        aTable.addRow(new Object[]{aDatabase});
                    }
                    aTable.output();
                }
            }
        }
        catch (Exception e) {
            throw new CliException((Throwable)e);
        }
    }

    private void validateCommands() {
        ArrayList commands = Lists.newArrayList();
        if (this.mAddSchema != null) {
            commands.add("--add");
        }
        if (this.mRemoveSchema != null) {
            commands.add("--remove");
        }
        if (this.mGetSchema != null) {
            commands.add("--show");
        }
        if (this.isList) {
            commands.add("--list");
        }
        if (commands.size() > 1) {
            throw new CliException(GraphQLSchemaCmd.get((String)"graphql.multiple.commands", (Object[])new Object[]{commands}));
        }
    }

    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 2) {
                throw new CliException(GraphQLSchemaCmd.get((String)"graphql.multiple.args", (Object[])new Object[0]));
            }
            if (this.mArgs.size() == 2) {
                if (this.mAddSchema == null) {
                    throw new CliException(GraphQLSchemaCmd.get((String)"graphql.multiple.args", (Object[])new Object[0]));
                }
                this.mSchemaFile = new File(this.mArgs.get(1));
            } else if (this.mAddSchema != null) {
                throw new CliException(GraphQLSchemaCmd.get((String)"graphql.schema.missing", (Object[])new Object[0]));
            }
        }
        return this.mDbName;
    }
}

