/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql.cli;

import com.complexible.common.base.Durations;
import com.complexible.common.io.Files2;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.graphql.GraphQLConnection;
import com.complexible.stardog.api.graphql.GraphQLQuery;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ConnectionCommand;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;

public abstract class GraphQLQueryCommand
extends ConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The subsequent argument is the GraphQL query to execute. This can either be a file name or a GraphQL query string.", title={"database", "query"})
    public final List<String> mArgs = Lists.newArrayList();
    @Option(description="Timeout for the query in ms. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds). Timeout value of 0 results in no timeout", name={"--timeout"}, title="N[h|m|s]")
    public String mTimeout = null;
    @Option(name={"--schema"}, description="Specify the name of the GraphQL schema that will be used for the query. If no schema is specified the query will use the automated translation rules and will not validate the query.", title="schema")
    public String mSchema;
    @Option(name={"-r", "--reasoning"}, description="Turn reasoning on.")
    public boolean mReasoningEnabled = false;
    protected String mDbName;
    protected String mQuery;
    protected boolean mIsFile;
    protected File mFile;

    @Inject
    public GraphQLQueryCommand(PasswordReader theReader) {
        super(theReader);
    }

    protected String getReasoningSchema() {
        return this.mReasoningEnabled ? "default" : Schemas.NULL;
    }

    public void execute(Connection theConn) throws StardogException {
        boolean aIsQuery;
        String aQueryStr = null;
        boolean bl = aIsQuery = this.mQuery != null && !this.mQuery.equals("");
        if (aIsQuery) {
            aQueryStr = this.mQuery;
        } else if (this.mIsFile) {
            if (!this.mFile.exists()) {
                throw new CliException(GraphQLQueryCommand.get((String)"error.nofile", (Object[])new Object[0]));
            }
            try {
                aQueryStr = Files2.toString((Path)this.mFile.toPath(), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new CliException((Throwable)e);
            }
        } else {
            throw new CliException(GraphQLQueryCommand.get((String)"error.noquery", (Object[])new Object[0]));
        }
        aQueryStr = CliUtil.cleanQuery((String)aQueryStr);
        if (StoredQuery.isValidName((String)aQueryStr)) {
            try {
                aQueryStr = theConn.admin().getStoredQueries().get(aQueryStr).getQuery();
            }
            catch (Exception e) {
                throw new StardogException("Stored query not found: " + aQueryStr);
            }
        }
        GraphQLConnection aConn = (GraphQLConnection)theConn.as(GraphQLConnection.class);
        GraphQLQuery aQuery = aConn.graphql(aQueryStr);
        if (this.mSchema != null) {
            aQuery.schema(this.mSchema);
        }
        if (this.mTimeout != null) {
            long aTimeout = Durations.parse((String)this.mTimeout);
            aQuery.timeout(aTimeout);
        }
        this.execute(aQuery);
    }

    protected abstract void execute(GraphQLQuery var1);

    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                String aParam = this.mArgs.get(1);
                this.mIsFile = new File(aParam).exists();
                this.mFile = new File(aParam);
                if (!this.mFile.exists()) {
                    this.mQuery = aParam;
                }
            }
        }
        return this.mDbName;
    }
}

