/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.catalog.cli;

import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.catalog.CatalogAdminConnection;
import com.complexible.stardog.catalog.CatalogJobStatus;
import com.complexible.stardog.catalog.CatalogProviderStatus;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;

@Command(name="status", description="Knowledge catalog system status")
public class CatalogStatus
extends SecureStardogAdminCommand<Void> {
    @Inject
    public CatalogStatus(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws Exception {
        CatalogAdminConnection catConn = (CatalogAdminConnection)theConn.as(CatalogAdminConnection.class);
        com.complexible.stardog.catalog.CatalogStatus status = catConn.getStatus();
        System.out.println("Stardog Knowledge Catalog");
        System.out.println();
        System.out.println("Metadata Provider Configurations");
        TextTabularOutput aOutput = new TextTabularOutput((OutputStream)System.out, new String[]{"Name", "Type", "Schedule"});
        for (CatalogProviderStatus pStat : status.getProviders()) {
            aOutput.addRow(new Object[]{pStat.getName(), pStat.getType(), pStat.getSchedule()});
        }
        aOutput.output();
        System.out.println();
        System.out.println("Scheduled Jobs");
        aOutput = new TextTabularOutput((OutputStream)System.out, new String[]{"Name", "Last Run", "Scheduled", "State"});
        for (CatalogJobStatus jobStat : status.getJobs()) {
            aOutput.addRow(new Object[]{jobStat.getName(), jobStat.getPrevRun(), jobStat.getNextRun(), jobStat.getJobState()});
        }
        aOutput.output();
        System.out.println();
        System.out.println("Job Scheduler Status");
        System.out.println("Scheduler: " + status.getScheduler());
        System.out.println("Running Since: " + status.getStartTime());
        System.out.println("Execution Threads: " + status.getThreadCount());
    }
}

