/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.catalog.cli;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.catalog.CatalogAdminConnection;
import com.complexible.stardog.catalog.CatalogProviderStatus;
import com.complexible.stardog.catalog.CatalogStatus;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import com.stardog.stark.Values;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="reload", description="Reload the catalog", examples={"* Reload only the Purview provider", "    $ stardog-admin catalog reload urn:purview", "", "* Reload all providers (including quotes to prevent shell from expanding wildcard)", "    $ stardog-admin catalog reload '*'"})
public class CatalogReload
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="The IRI for the provider to be reloaded or asterisk to reload all providers.", title={"provider"})
    public String mProvider;

    @Inject
    public CatalogReload(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) {
        CatalogAdminConnection catConn = (CatalogAdminConnection)theConn.as(CatalogAdminConnection.class);
        System.out.println("Reloading catalog data...");
        if (this.mProvider.equals("*")) {
            CatalogStatus status = catConn.getStatus();
            for (CatalogProviderStatus provider : status.getProviders()) {
                this.reloadCatalog(catConn, provider.getName());
            }
        } else {
            this.reloadCatalog(catConn, this.mProvider);
        }
        System.out.println("Reload completed");
    }

    private void reloadCatalog(CatalogAdminConnection catConn, String name) {
        System.out.print("> " + name);
        try {
            catConn.reloadCatalog(Values.iri((String)name));
            System.out.println(" - done");
        }
        catch (Error | RuntimeException e) {
            System.out.println();
            throw e;
        }
    }
}

