/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.catalog.cli;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.catalog.CatalogAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.UUID;

@Command(name="credentials-remove", description="Remove stored credentials for external metadata sources")
public class CatalogCredentialsRemove
extends SecureStardogAdminCommand<Void> {
    @Arguments(required=true, description="Remove a credential from the catalog", title={"credential"})
    public String mKey;

    @Inject
    public CatalogCredentialsRemove(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws Exception {
        CatalogAdminConnection catConn = (CatalogAdminConnection)theConn.as(CatalogAdminConnection.class);
        catConn.removeCredential(UUID.fromString(this.mKey));
    }
}

