/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.catalog.cli;

import com.complexible.common.base.Pair;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.catalog.CatalogAdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import java.io.OutputStream;
import java.util.List;

@Command(name="credentials-list", description="List stored credentials for external metadata sources")
public class CatalogCredentialsList
extends SecureStardogAdminCommand<Void> {
    @Inject
    public CatalogCredentialsList(PasswordReader theReader) {
        super(theReader);
    }

    public void performSecure(AdminConnection theConn) throws Exception {
        CatalogAdminConnection catConn = (CatalogAdminConnection)theConn.as(CatalogAdminConnection.class);
        System.out.println();
        System.out.println("Catalog Stored Credentials");
        TextTabularOutput aOutput = new TextTabularOutput((OutputStream)System.out, new String[]{"Access Key", "Description"});
        List creds = catConn.listCredentials();
        for (Pair cred : creds) {
            aOutput.addRow(new Object[]{cred.first, cred.second == null ? "" : cred.second});
        }
        aOutput.output();
    }
}

