/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.catalog.cli;

import com.complexible.common.base.Pair;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.catalog.CatalogAdminConnection;
import com.complexible.stardog.catalog.Credentials;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.nio.file.Files;
import org.apache.logging.log4j.util.Strings;

@Command(name="credentials-add", description="Add stored credentials for external metadata sources", discussion="Add stored credentials for external metadata sources. Credentials can be provided interactively, via command-line options, or via a JSON file. When a JSON file is provided, no interactive prompts are shown. The JSON file format matches the REST API:\n\n  Username/Password: {\"username\":\"...\",\"password\":\"...\",\"label\":\"...\"}\n  Client credentials: {\"clientId\":\"...\",\"clientSecret\":\"...\",\"label\":\"...\"}\n  Token: {\"token\":\"...\",\"label\":\"...\"}\n\nExternal secrets can be included:\n  {\"username\":\"{user}\",\"password\":\"{pass}\",\"label\":\"...\",\n   \"secret\":{\"manager\":\"<secret-manager-iri>\",\"id\":\"<secret-id>\"}}")
public class CatalogCredentialsAdd
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-f", "--file"}, description="Path to a JSON file containing the credentials. When provided, no interactive prompts are shown.", title="file")
    public String mFile;
    @Option(name={"--client-id"}, description="Client ID for OAuth/client credential authentication", title="clientId")
    public String mClientId;
    @Option(name={"--client-secret"}, description="Client secret for OAuth/client credential authentication", title="clientSecret")
    public String mClientSecret;
    @Option(name={"--creds-token"}, description="Token for token-based authentication (e.g., API token, bearer token) for the credential being added", title="authToken")
    public String mAuthToken;
    @Option(name={"--creds-username"}, description="Username for username/password authentication for the credential being added", title="credsUsername")
    public String mCredsUsername;
    @Option(name={"--creds-password"}, description="Password for username/password authentication for the credential being added", title="credsPassword")
    public String mCredsPassword;
    @Option(name={"-l", "--label"}, description="Description/label for the credentials", title="label")
    public String mLabel;
    PasswordReader mReader;

    @Inject
    public CatalogCredentialsAdd(PasswordReader theReader) {
        super(theReader);
        this.mReader = theReader;
    }

    public void performSecure(AdminConnection theConn) throws Exception {
        Credentials creds;
        String label;
        CatalogAdminConnection catConn = (CatalogAdminConnection)theConn.as(CatalogAdminConnection.class);
        String string = label = this.mLabel != null ? this.mLabel : "";
        if (this.mFile != null) {
            File aFile = new File(this.mFile);
            if (!aFile.exists()) {
                throw new CliException("File not found: " + this.mFile);
            }
            String aJson = Files.readString(aFile.toPath());
            Pair result = Credentials.fromJson((String)aJson);
            creds = (Credentials)result.first();
            if (this.mLabel == null) {
                label = (String)result.second();
            } else if (!Strings.isBlank((String)label)) {
                throw new CliException("Label specified both in file and via --label option");
            }
        } else if (this.mClientId != null || this.mClientSecret != null) {
            if (this.mClientId == null || this.mClientSecret == null) {
                throw new CliException("Both --client-id and --client-secret must be provided together");
            }
            creds = new Credentials();
            creds.add("clientId", this.mClientId);
            creds.add("clientSecret", this.mClientSecret);
        } else if (this.mAuthToken != null) {
            creds = new Credentials();
            creds.add("token", this.mAuthToken);
        } else if (this.mCredsUsername != null || this.mCredsPassword != null) {
            if (this.mCredsUsername == null || this.mCredsPassword == null) {
                throw new CliException("Both --creds-username and --creds-password must be provided together");
            }
            creds = new Credentials();
            creds.add("username", this.mCredsUsername);
            creds.add("password", this.mCredsPassword);
        } else if (this.mReader != null) {
            String username = this.mReader.readLine("Username: ", new Object[0]);
            char[] password = this.mReader.readPassword("Password: ", new Object[0]);
            if (this.mLabel == null) {
                label = this.mReader.readLine("Description (optional): ", new Object[0]);
            }
            creds = new Credentials();
            creds.add("username", username);
            creds.add("password", new String(password));
        } else {
            throw new CliException("No credentials provided. Use --file, --client-id/--client-secret, --creds-token, --creds-username/--creds-password, or interactive mode.");
        }
        String key = catConn.addCredentials(creds, label);
        System.out.println();
        System.out.println(key);
    }
}

