/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql;

import com.google.common.collect.ImmutableSet;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;

public class StardogDirectives {
    public static final GraphQLDirective TYPE = GraphQLDirective.newDirective().name("type").description("Flag to indicate that the field represents a type and not a regular property").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FRAGMENT_SPREAD, Introspection.DirectiveLocation.INLINE_FRAGMENT, Introspection.DirectiveLocation.FIELD}).build();
    public static final GraphQLDirective HIDE = GraphQLDirective.newDirective().name("hide").description("Flag to indicate that the field should not be included in the results").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD}).build();
    public static final GraphQLDirective OPTIONAL = GraphQLDirective.newDirective().name("optional").description("Flag to indicate that the field is optional").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD}).build();
    public static final GraphQLDirective FILTER = GraphQLDirective.newDirective().name("filter").description("Directs the executor to return the enclosing object when the `if` expression evaluates to true.").argument(GraphQLArgument.newArgument().name("if").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).description("SPARQL expression.")).validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD}).build();
    public static final GraphQLDirective BIND = GraphQLDirective.newDirective().name("bind").description("Directs the executor to compute the field value by evaluating the `to` expression.").argument(GraphQLArgument.newArgument().name("to").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).description("SPARQL expression.")).validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD}).build();
    public static final GraphQLDirective CONFIG = GraphQLDirective.newDirective().name("config").description("Stardog specific configuration options.").argument(GraphQLArgument.newArgument().name("type").type((GraphQLInputType)Scalars.GraphQLBoolean).description("Config option that indicates the top-level field is a type")).argument(GraphQLArgument.newArgument().name("alias").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).description("Config option to define GraphQL-safe aliases for IRIs. The input should be one or more input objects where the key is the GraphQL-safe name and the value is a full IRI string or a GraphQL-safe prefixed name in the format prefix_name.")).argument(GraphQLArgument.newArgument().name("graph").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).description("Config option to define the named graph scope for the query. The input should be one or more graph IRIs either as a full IRI string or as a a GraphQL-safe prefixed name in the format prefix_name.")).validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.QUERY}).build();
    public static final GraphQLDirective PREFIX = GraphQLDirective.newDirective().name("prefix").description("Prefix definitions for namespaces.").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.QUERY}).build();
    public static final GraphQLDirective LANG = GraphQLDirective.newDirective().name("lang").description("Flag to indicate that returned value should include the language of a literal in addition to the literal itself. Has no effect unless the literal is a language-tagged string value.").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD}).build();
    public static final GraphQLDirective HINT = GraphQLDirective.newDirective().name("hint").description("Stardog preamble hints.").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.QUERY}).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).description("list of hints in name=value format")).build();
    public static final ImmutableSet<GraphQLDirective> ALL = ImmutableSet.of((Object)TYPE, (Object)HIDE, (Object)OPTIONAL, (Object)FILTER, (Object)BIND, (Object)CONFIG, (Object[])new GraphQLDirective[]{PREFIX, LANG, HINT});

    public static class SchemaDirectives {
        public static final GraphQLDirective IRI = GraphQLDirective.newDirective().name("iri").description("Schema directive for associating objects or fields with IRIs").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION, Introspection.DirectiveLocation.OBJECT}).argument(GraphQLArgument.newArgument().name("namespace").type((GraphQLInputType)Scalars.GraphQLString).description("Namespace for the IRI. Full IRI is constructed by combining this namespace with the GraphQL name.")).argument(GraphQLArgument.newArgument().name("prefix").type((GraphQLInputType)Scalars.GraphQLString).description("Prefix for the IRI. Full IRI is constructed by combining the namespace associated with this prefix with the GraphQL name.")).argument(GraphQLArgument.newArgument().name("localname").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).description("Localname for the IRI to be used instead of the GraphQL name. The localname will be prefixed with the namespace to construct the IRI.")).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).description("Value for the IRI. This value is used as the IRI.")).build();
    }
}

