/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.language.SourceLocation;
import graphql.org.antlr.v4.runtime.RecognitionException;
import java.util.List;

public class GraphQLGenericError
implements GraphQLError {
    private static final String PREFIX = "GraphQL Error";
    private final String message;
    private final List<SourceLocation> locations;
    private final ErrorType errorType;

    private GraphQLGenericError(ImmutableList<SourceLocation> sourceLocations, String msg) {
        this(sourceLocations, msg, ErrorType.InvalidSyntax);
    }

    private GraphQLGenericError(ImmutableList<SourceLocation> sourceLocations, String msg, ErrorType errorType) {
        this.message = msg == null ? PREFIX : msg;
        this.locations = sourceLocations;
        this.errorType = (ErrorType)Preconditions.checkNotNull((Object)errorType, (Object)"Error type cannot be null");
    }

    public String getMessage() {
        return this.message;
    }

    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String toString() {
        return "GraphQLError{message=" + this.message + " ,locations=" + String.valueOf(this.locations) + "}";
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals((GraphQLError)this, (Object)o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode((GraphQLError)this);
    }

    public static GraphQLGenericError create(Exception parseException) {
        String msg = parseException.getMessage();
        if (parseException.getCause() instanceof RecognitionException) {
            RecognitionException recognitionException = (RecognitionException)parseException.getCause();
            msg = recognitionException.getMessage() == null ? "Syntax error" : recognitionException.getMessage();
            SourceLocation sourceLocation = new SourceLocation(recognitionException.getOffendingToken().getLine(), recognitionException.getOffendingToken().getCharPositionInLine());
            return GraphQLGenericError.create(msg, sourceLocation);
        }
        return GraphQLGenericError.create(msg);
    }

    public static GraphQLGenericError create(String msg) {
        return new GraphQLGenericError((ImmutableList<SourceLocation>)ImmutableList.of(), msg);
    }

    public static GraphQLGenericError create(String msg, SourceLocation location) {
        return new GraphQLGenericError((ImmutableList<SourceLocation>)ImmutableList.of((Object)location), msg);
    }

    public static GraphQLGenericError create(String msg, List<SourceLocation> locations) {
        return new GraphQLGenericError((ImmutableList<SourceLocation>)ImmutableList.copyOf(locations), msg);
    }

    public static GraphQLGenericError create(String msg, List<SourceLocation> locations, ErrorType errorType) {
        return new GraphQLGenericError((ImmutableList<SourceLocation>)ImmutableList.copyOf(locations), msg, errorType);
    }

    public static GraphQLGenericError create(String msg, ErrorType errorType) {
        return new GraphQLGenericError((ImmutableList<SourceLocation>)ImmutableList.of(), msg, errorType);
    }
}

