/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.graphql;

import com.complexible.common.base.Options;
import com.complexible.common.util.PrefixMapping;
import com.complexible.stardog.graphql.GraphQLSchemas;
import com.complexible.stardog.graphql.StardogDirectives;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelWriter;
import com.stardog.model.DataModelWriterOptions;
import com.stardog.model.NameFormatters;
import com.stardog.model.Property;
import com.stardog.model.Type;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.OWL;
import com.stardog.stark.Values;
import graphql.Scalars;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.util.Strings;

public class GraphQLDataModelWriter
implements DataModelWriter {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[_A-Za-z][_0-9A-Za-z]*");
    private PrefixMapping prefixes = new PrefixMapping();
    private Set<String> typeNames = Sets.newHashSet();
    private Map<String, FormattedName> formattedNames = Maps.newHashMap();

    public DataModelFormat getFormat() {
        return DataModelFormat.GRAPHQL;
    }

    public GraphQLSchema write(DataModel model, Options options) {
        ((Iterable)options.get(DataModelWriterOptions.NAMESPACES)).forEach(ns -> this.prefixes.setMapping(ns.prefix(), ns.iri()));
        this.typeNames.clear();
        this.formattedNames.clear();
        this.typeNames.add(Scalars.GraphQLID.getName());
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject().name("QueryType");
        for (Type entity : model.getTypes()) {
            GraphQLObjectType type;
            if (entity.isDatatype() || entity.isBuiltin() || (type = this.createObjectType(entity)) == null) continue;
            queryType.field(GraphQLFieldDefinition.newFieldDefinition().name(type.getName()).type((GraphQLOutputType)type));
        }
        return GraphQLSchema.newSchema().query(queryType).withSchemaDirective(StardogDirectives.SchemaDirectives.IRI).additionalDirective(StardogDirectives.SchemaDirectives.IRI).additionalDirectives(StardogDirectives.ALL).build();
    }

    public void write(OutputStream out, DataModel model, Options options) {
        GraphQLSchema schema = this.write(model, options);
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        ps.println(GraphQLSchemas.write(schema));
    }

    private GraphQLObjectType createObjectType(Type cls) {
        FormattedName name = this.formatName(cls);
        GraphQLObjectType.Builder builder = ((GraphQLObjectType.Builder)GraphQLObjectType.newObject().name(name.formatted).withAppliedDirectives(name.createDirectives())).field(GraphQLFieldDefinition.newFieldDefinition().name("iri").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLID)));
        this.addFields(builder, cls, Sets.newHashSet());
        GraphQLObjectType type = builder.build();
        return type;
    }

    private void addFields(GraphQLObjectType.Builder builder, Type cls, Set<String> properties) {
        HashSet usedNames = Sets.newHashSet((Object[])new String[]{"iri"});
        for (Property prop : cls.getProperties()) {
            if (!properties.add(prop.getName())) continue;
            this.addField(builder, prop, usedNames);
        }
        for (Type sup : cls.getSupers()) {
            this.addFields(builder, sup, properties);
        }
    }

    private void addField(GraphQLObjectType.Builder builder, Property prop, Set<String> fields) {
        FormattedName fieldName = this.formatName(prop.getName(), fields);
        GraphQLOutputType range = prop.getRange().map(this::outputType).orElse((GraphQLOutputType)Scalars.GraphQLID);
        if (prop.getMaxCardinality().orElse(2) > 1) {
            range = GraphQLList.list((GraphQLType)range);
        }
        if (prop.getMinCardinality().orElse(0) > 0) {
            range = GraphQLNonNull.nonNull((GraphQLType)range);
        }
        builder.field(((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(fieldName.formatted).withAppliedDirectives(fieldName.createDirectives())).type(range));
    }

    private FormattedName formatName(Type type) {
        return this.formatName(type.getName(), this.typeNames);
    }

    private FormattedName formatName(String name, Set<String> usedNames) {
        FormattedName result = this.formattedNames.get(name);
        if (result != null) {
            return result;
        }
        boolean requiresDirective = false;
        Object formattedName = this.prefixes.qname(name, false);
        if (!name.equals(formattedName)) {
            formattedName = ((String)formattedName).startsWith(":") ? ((String)formattedName).substring(1) : ((String)formattedName).replaceFirst(":", "_");
        }
        if (!this.isValidName((String)formattedName, usedNames)) {
            requiresDirective = true;
            formattedName = (String)NameFormatters.localname().apply(name);
            if (Character.isDigit(((String)(formattedName = ((String)formattedName).replaceAll("[^_0-9A-Za-z]", ""))).charAt(0))) {
                formattedName = "_" + (String)formattedName;
            }
            Preconditions.checkState((boolean)this.isValidName((String)formattedName, (Set<String>)ImmutableSet.of()));
            Object baseName = formattedName;
            int i = 0;
            while (usedNames.contains(formattedName)) {
                formattedName = (String)baseName + i;
                ++i;
            }
        }
        usedNames.add((String)formattedName);
        result = new FormattedName(name, (String)formattedName, requiresDirective);
        this.formattedNames.put(name, result);
        return result;
    }

    private boolean isValidName(String name, Set<String> usedNames) {
        return !Strings.isEmpty((CharSequence)name) && !usedNames.contains(name) && VALID_NAME_PATTERN.matcher(name).matches();
    }

    private GraphQLOutputType outputType(Type type) {
        if (type.isDatatype()) {
            return this.datatype(type);
        }
        if (type.getName().equals(com.stardog.stark.Value.lex((com.stardog.stark.Value)OWL.THING))) {
            return Scalars.GraphQLID;
        }
        return new GraphQLTypeReference(this.formatName((Type)type).formatted);
    }

    private GraphQLOutputType datatype(Type type) {
        Datatype dt = Datatype.of((IRI)Values.iri((String)type.getName()));
        switch (dt) {
            case BOOLEAN: {
                return Scalars.GraphQLBoolean;
            }
            case DOUBLE: {
                return Scalars.GraphQLFloat;
            }
            case FLOAT: {
                return Scalars.GraphQLFloat;
            }
            case BYTE: 
            case SHORT: 
            case UNSIGNED_SHORT: 
            case UNSIGNED_BYTE: 
            case INT: 
            case INTEGER: 
            case NON_POSITIVE_INTEGER: 
            case NEGATIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case POSITIVE_INTEGER: 
            case UNSIGNED_INT: 
            case UNSIGNED_LONG: 
            case LONG: {
                return Scalars.GraphQLInt;
            }
        }
        return Scalars.GraphQLString;
    }

    private static class FormattedName {
        private final String name;
        private final String formatted;
        private final boolean requiresDirective;

        private FormattedName(String name, String formatted, boolean requiresDirective) {
            this.name = name;
            this.formatted = formatted;
            this.requiresDirective = requiresDirective;
        }

        private GraphQLAppliedDirective[] createDirectives() {
            if (this.requiresDirective) {
                return new GraphQLAppliedDirective[]{this.createDirective()};
            }
            return new GraphQLAppliedDirective[0];
        }

        private GraphQLAppliedDirective createDirective() {
            return ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name(StardogDirectives.SchemaDirectives.IRI.getName())).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name("value")).type((GraphQLInputType)Scalars.GraphQLString).valueLiteral((Value)new StringValue(this.name)).build()).build();
        }
    }
}

