/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cache;

import com.complexible.stardog.cache.CacheTarget;
import com.complexible.stardog.cache.CachedGraph;
import com.complexible.stardog.cache.api.CachedDatasetStatus;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.function.Function;

public class CacheMetadataSerializers {
    private static <T, R> R coalesce(T element, R ifNull, Function<T, R> f) {
        if (element == null) {
            return ifNull;
        }
        return f.apply(element);
    }

    private static String jsonStringOrNull(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        return element.getAsString();
    }

    public static JsonObject cacheTargetToJson(CacheTarget ct) {
        return CacheMetadataSerializers.cacheTargetToJson(ct, true);
    }

    public static JsonObject cacheTargetToJson(CacheTarget ct, boolean obfuscatePassword) {
        String password = obfuscatePassword ? "********" : ct.getPassword();
        JsonObject obj = new JsonObject();
        obj.add("name", (JsonElement)new JsonPrimitive(ct.getName()));
        obj.add("hostname", (JsonElement)new JsonPrimitive(ct.getHostname()));
        obj.add("port", (JsonElement)new JsonPrimitive((Number)ct.getPort()));
        obj.add("username", (JsonElement)new JsonPrimitive(ct.getUsername()));
        obj.add("password", (JsonElement)new JsonPrimitive(password));
        return obj;
    }

    public static CacheTarget cacheTargetFromJson(JsonElement el) {
        JsonObject o = el.getAsJsonObject();
        return new CacheTarget(o.get("name").getAsString(), o.get("hostname").getAsString(), o.get("port").getAsInt(), o.get("username").getAsString(), o.get("password").getAsString()){};
    }

    public static JsonObject cachedGraphToJson(CachedGraph cg) {
        JsonObject obj = new JsonObject();
        obj.add("name", (JsonElement)new JsonPrimitive(Value.lex((Value)cg.getName())));
        obj.add("database", (JsonElement)new JsonPrimitive(cg.getDatabase()));
        obj.add("refreshScript", CacheMetadataSerializers.coalesce(cg.getRefreshScript(), JsonNull.INSTANCE, JsonPrimitive::new));
        obj.add("target", (JsonElement)CacheMetadataSerializers.cacheTargetToJson(cg.getTarget()));
        obj.add("graph", (JsonElement)new JsonPrimitive(Value.lex((Value)cg.getGraphName())));
        obj.add("computeSource", CacheMetadataSerializers.coalesce(cg.getExternalComputeSourceName(), JsonNull.INSTANCE, JsonPrimitive::new));
        obj.add("partitionColumn", CacheMetadataSerializers.coalesce(cg.getExternalComputeJDBCSourcePartitionColumn(), JsonNull.INSTANCE, JsonPrimitive::new));
        return obj;
    }

    public static CachedGraph cachedGraphFromJson(JsonElement el) {
        JsonObject o = el.getAsJsonObject();
        return new CachedGraph(Values.iri((String)o.get("name").getAsString()), o.get("database").getAsString(), CacheMetadataSerializers.jsonStringOrNull(o.get("refreshScript")), CacheMetadataSerializers.cacheTargetFromJson(o.get("target")), Values.iri((String)o.get("graph").getAsString()), CacheMetadataSerializers.jsonStringOrNull(o.get("computeSource")), CacheMetadataSerializers.jsonStringOrNull(o.get("partitionColumn"))){};
    }

    public static JsonObject cachedDatasetStatusToJson(CachedDatasetStatus status) {
        JsonObject obj = new JsonObject();
        obj.add("name", (JsonElement)new JsonPrimitive(status.getName().toString()));
        obj.add("target", (JsonElement)new JsonPrimitive(status.getTargetName()));
        obj.add("size", (JsonElement)new JsonPrimitive((Number)status.getSize()));
        obj.add("lastRefresh", (JsonElement)new JsonPrimitive(status.getLastRefreshed().toXMLFormat()));
        return obj;
    }

    public static CachedDatasetStatus cachedDatasetStatusFromJson(JsonElement el) {
        JsonObject o = el.getAsJsonObject();
        return new CachedDatasetStatus(Values.iri((String)o.get("name").getAsString()), o.get("target").getAsString(), o.get("size").getAsLong(), Values.DATATYPE_FACTORY.newXMLGregorianCalendar(o.get("lastRefresh").getAsString()));
    }
}

