/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.entityresolution.cli;

import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.ParameterizedQueryCommand;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ReasonableConnectionCommand;
import com.complexible.stardog.enityresolution.api.EntityResolutionConnection;
import com.complexible.stardog.enityresolution.api.EntityResolutionType;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Command(name="resolve", description="Resolve the entities. Creates the edge between duplicate entities. It is recommended to use external compute for this functionalityby using --compute option.", examples={"* Resolve the entities with the default settings. Please refer to the documentation for a complete query example", "    $ stardog entity-resolution resolve myDB \"select * {  ?person a :Person ; \u2026 }\" \"person\" \"test:myTargetNamedGraph\"", "", "* Use external compute to resolve the entities. Please refer to the documentation for a complete query example", "    $ stardog entity-resolution resolve myDb \"select * {  ?person a :Person ; \u2026 }\" \"person\" \"test:myTargetNamedGraph\" -c my_external_compute_datasource_name", "", "* Use external compute to resolve the entities with score. Please refer to the documentation for a complete query example", "    $ stardog entity-resolution resolve myDb \"select * {  ?person a :Person ; \u2026 }\" \"person\" \"test:myTargetNamedGraph\" -c my_external_compute_datasource_name -i true", ""})
public class EntityResolutionResolveEntitiesCmd
extends ReasonableConnectionCommand<Void> {
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https.\nThe subsequent arguments are the SPARQL query to execute, the name of the IRI field in the SPARQL query representing the entity to resolve, and the target named graph. The entity resolution process will run on the results of this SPARQL query for the entity represented by the IRI field and will write the results to the target named graph.", title={"database", "query", "iri", "target-named-graph"})
    public final List<String> mArgs = Lists.newArrayList();
    @Option(name={"-c", "--compute"}, title="compute source", description="The external compute data source for the entity resolution. If provided, the entity resolution process will run on compute server and will write the results to the Stardog. The compute source should be the name of the data source when the external compute platform is Databricks. For emr-serverless as an external compute platform, this should be the file path containing the required properties for emr-serverless. If not provided, entity resolution will run inside the stardog process and is only recommended for smaller graphs i.e. having less than 100K triples.")
    public String mComputeSource;
    @Option(name={"-e", "--edge-type"}, description="Entity resolution will create an edge of this type in the output to link the duplicate entities. If not provided, it will generate an edge of type tag:stardog:api:entityMatch.", title="edge type")
    public String mEdgeLabel = "tag:stardog:api:entityMatch";
    @Option(name={"-i", "--include-score"}, description="Include the score in the entity resolution output. If not provided, the result will not include the score. This is only supported with compute option.", title="include score")
    public boolean mIncludeScore = false;
    @Option(name={"-f", "--properties file"}, description="The properties file for the entity resolution configuration. If not provided, entity resolution will run on default configurations", title="er config properties")
    public String mPropertyFile;
    public String mDbName;
    private String mQuery;
    private String mIRIFieldNameInQueryResults;
    private String mTargetNamedGraph;
    private File mFile;

    @Inject
    public EntityResolutionResolveEntitiesCmd(PasswordReader passwordReader) {
        super(passwordReader);
    }

    public void execute(Connection httpConnection) throws StardogException {
        Stopwatch w = Stopwatch.createStarted();
        Properties erProperties = new Properties();
        try {
            if (this.mPropertyFile != null && !this.mPropertyFile.isEmpty()) {
                Path aPropsFile = Paths.get(this.mPropertyFile, new String[0]);
                erProperties.load(Files.newInputStream(aPropsFile, new OpenOption[0]));
            }
        }
        catch (IOException e) {
            throw new CliException("Unable to read configuration file: " + this.mPropertyFile);
        }
        try {
            File computeFile;
            EntityResolutionConnection entityResolutionConnection = (EntityResolutionConnection)httpConnection.as(EntityResolutionConnection.class);
            this.mQuery = this.mFile.exists() ? ParameterizedQueryCommand.readQueryString((File)this.mFile, null) : CliUtil.storedQueryString((String)this.mQuery, (Connection)httpConnection);
            if (this.mComputeSource != null && (computeFile = new File(this.mComputeSource)).isFile()) {
                try {
                    this.mComputeSource = Files.lines(Paths.get(this.mComputeSource, new String[0])).collect(Collectors.joining(";"));
                }
                catch (RuntimeException e) {
                    throw new CliException("Error reading compute properties file '" + computeFile.getAbsolutePath() + "'. " + e.getMessage(), (Throwable)e);
                }
            }
            entityResolutionConnection.resolveEntities(this.mTargetNamedGraph, this.mQuery, this.mIRIFieldNameInQueryResults, this.mComputeSource, this.mEdgeLabel, EntityResolutionType.UNSUPERVISED, this.mIncludeScore, erProperties);
            long duration = w.elapsed(TimeUnit.MILLISECONDS);
            System.out.printf("Resolve completed successfully in %s.%n", DurationFormat.LONG.format(duration));
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new CliException(e.getCause());
            }
            throw new CliException(e.getMessage());
        }
    }

    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (!this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 3) {
                this.mQuery = this.mArgs.get(1);
                this.mFile = new File(this.mQuery);
                this.mIRIFieldNameInQueryResults = this.mArgs.get(2);
                this.mTargetNamedGraph = this.mArgs.get(3);
            } else {
                throw new StardogException("\"database\",\"query\",\"iri\" and \"target-named-graph\" are required arguments");
            }
        }
        return this.mDbName;
    }
}

