/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.google.common.collect.ImmutableMap;
import com.stardog.stark.Value;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.query.Dataset;
import com.stardog.stark.query.Datasets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public interface QueryRequest {
    public String query();

    public String baseURI();

    public String id();

    public Map<String, Value> bindings();

    public Map<String, String> hints();

    public Dataset dataset();

    public long limit();

    public long offset();

    public Optional<UUID> tx();

    public long timeout();

    public String schema();

    public FileFormat format();

    public boolean isVerbose();

    public boolean profiling();

    public boolean refreshGraphAliases();

    public static QueryRequest create(String theQuery, String theBaseURI) {
        return QueryRequest.newRequest(theQuery, theBaseURI).build();
    }

    public static QueryRequestBuilder newRequest(String theQuery, String theBaseURI) {
        return new QueryRequestBuilder(theQuery, theBaseURI);
    }

    public static final class QueryRequestBuilder {
        private String mID = "";
        private final String mQuery;
        private final String mBaseURI;
        private Map<String, Value> mBindings = ImmutableMap.of();
        private Map<String, String> mHints = ImmutableMap.of();
        private Dataset mDataset = Datasets.NO_DATASET;
        private long mLimit = -1L;
        private long mOffset = -1L;
        private long mTimeout = -1L;
        private UUID mTx = null;
        private String mSchema = null;
        private boolean mVerbose = false;
        private boolean mProfile = false;
        private FileFormat mFormat = null;
        private boolean mRefreshGA = false;

        public QueryRequestBuilder(String theQuery, String theBaseURI) {
            this.mBaseURI = theBaseURI;
            this.mQuery = theQuery;
        }

        QueryRequestBuilder parameters(Map<String, Value> theParams) {
            this.mBindings = theParams;
            return this;
        }

        QueryRequestBuilder id(String theID) {
            this.mID = theID;
            return this;
        }

        QueryRequestBuilder tx(UUID theTx) {
            this.mTx = theTx;
            return this;
        }

        QueryRequestBuilder limit(long theLimit) {
            this.mLimit = theLimit;
            return this;
        }

        QueryRequestBuilder offset(long theOffset) {
            this.mOffset = theOffset;
            return this;
        }

        QueryRequestBuilder dataset(Dataset theDataset) {
            this.mDataset = theDataset;
            return this;
        }

        QueryRequestBuilder timeout(long theTimeout) {
            this.mTimeout = theTimeout;
            return this;
        }

        QueryRequestBuilder schema(String theSchema) {
            this.mSchema = theSchema;
            return this;
        }

        QueryRequestBuilder format(FileFormat theFormat) {
            this.mFormat = theFormat;
            return this;
        }

        QueryRequestBuilder verbose(boolean theVerbose) {
            this.mVerbose = theVerbose;
            return this;
        }

        QueryRequestBuilder profile(boolean theProfile) {
            this.mProfile = theProfile;
            return this;
        }

        QueryRequestBuilder refreshGraphAliases(boolean theRefreshGA) {
            this.mRefreshGA = theRefreshGA;
            return this;
        }

        public QueryRequestBuilder hints(Map<String, String> theHints) {
            this.mHints = theHints;
            return this;
        }

        public QueryRequest build() {
            return new QueryRequestImpl(this);
        }
    }

    public static final class QueryRequestImpl
    implements QueryRequest {
        private final String mQuery;
        private final String mBaseURI;
        private final String mID;
        private final Map<String, Value> mBindings;
        private final Map<String, String> mHints;
        private final Dataset mDataset;
        private final long mLimit;
        private final long mOffset;
        private final UUID mTx;
        private final long mTimeout;
        private final String mSchema;
        private final boolean mVerbose;
        private final boolean mProfile;
        private FileFormat mFormat;
        private final boolean mRefreshGA;

        private QueryRequestImpl(QueryRequestBuilder builder) {
            this.mQuery = builder.mQuery;
            this.mBaseURI = builder.mBaseURI;
            this.mID = builder.mID;
            this.mTx = builder.mTx;
            this.mBindings = builder.mBindings;
            this.mHints = builder.mHints;
            this.mDataset = builder.mDataset;
            this.mLimit = builder.mLimit;
            this.mOffset = builder.mOffset;
            this.mTimeout = builder.mTimeout;
            this.mSchema = builder.mSchema;
            this.mVerbose = builder.mVerbose;
            this.mProfile = builder.mProfile;
            this.mFormat = builder.mFormat;
            this.mRefreshGA = builder.mRefreshGA;
        }

        @Override
        public String query() {
            return this.mQuery;
        }

        @Override
        public String baseURI() {
            return this.mBaseURI;
        }

        @Override
        public String id() {
            return this.mID;
        }

        @Override
        public Map<String, Value> bindings() {
            return this.mBindings;
        }

        @Override
        public Map<String, String> hints() {
            return this.mHints;
        }

        @Override
        public Dataset dataset() {
            return this.mDataset;
        }

        @Override
        public long limit() {
            return this.mLimit;
        }

        @Override
        public long offset() {
            return this.mOffset;
        }

        @Override
        public String schema() {
            return this.mSchema;
        }

        @Override
        public boolean isVerbose() {
            return this.mVerbose;
        }

        @Override
        public boolean profiling() {
            return this.mProfile;
        }

        @Override
        public boolean refreshGraphAliases() {
            return this.mRefreshGA;
        }

        @Override
        public FileFormat format() {
            return this.mFormat;
        }

        @Override
        public long timeout() {
            return this.mTimeout;
        }

        @Override
        public Optional<UUID> tx() {
            return Optional.ofNullable(this.mTx);
        }
    }
}

