/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Options;
import com.complexible.common.base.Strings2;
import com.complexible.common.inject.OptionalConstructorParam;
import com.complexible.common.view.Views;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.ConnectionCredentials;
import com.complexible.stardog.api.ConnectionView;
import com.complexible.stardog.api.Driver;
import com.complexible.stardog.api.LoginConnectionConfiguration;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.AdminConnectionView;
import com.complexible.stardog.protocols.http.client.AdminConnectionImpl;
import com.complexible.stardog.protocols.http.client.HttpAdminClientImpl;
import com.complexible.stardog.protocols.http.client.HttpConnection;
import com.complexible.stardog.server.StardogConnectionException;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.hc.client5.http.auth.Credentials;

public final class HttpDriver
implements Driver {
    private final Views<Connection> mConnectionViews;
    private final Views<AdminConnection> mAdminConnectionViews;

    @Inject
    public HttpDriver(OptionalConstructorParam<Set<ConnectionView>> theConnectionViews, OptionalConstructorParam<Set<AdminConnectionView>> theAdminConnectionViews) {
        this.mConnectionViews = Views.of((Set)((Set)theConnectionViews.or(Collections.emptySet())));
        this.mAdminConnectionViews = Views.of((Set)((Set)theAdminConnectionViews.or(Collections.emptySet())));
    }

    public Connection connect(String theURL, Options theOptions) throws StardogException {
        if (this.acceptsURL(theURL)) {
            try {
                URI aURI = new URI(theURL);
                if (aURI.getHost() == null) {
                    throw new StardogException(theURL + " is an invalid connection string.");
                }
                int aPort = aURI.getPort() != -1 ? aURI.getPort() : 5820;
                aURI = new URI(aURI.getScheme(), aURI.getUserInfo(), aURI.getHost(), aPort, aURI.getPath(), aURI.getQuery(), aURI.getFragment());
                ConnectionCredentials aCreds = null;
                Supplier aCredSupplier = (Supplier)theOptions.get(ConnectionConfiguration.CREDENTIALS_SUPPLIER);
                aCreds = aCredSupplier != null ? (ConnectionCredentials)aCredSupplier.get() : (ConnectionCredentials)theOptions.get(ConnectionConfiguration.CREDENTIALS);
                if (aCreds == null) {
                    String aUsername = (String)theOptions.get(LoginConnectionConfiguration.USERNAME);
                    String aPasswd = (String)theOptions.get(LoginConnectionConfiguration.PASSWORD);
                    return HttpConnection.create(this.mConnectionViews, aURI, aUsername, aPasswd, theOptions);
                }
                Credentials aCredentials = aCreds.getHttpCredentials();
                return HttpConnection.create(this.mConnectionViews, aURI, aCredentials, theOptions);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException(e.getMessage());
            }
        }
        throw new StardogException("The HTTP driver does not accept URLs of the provided form");
    }

    public AdminConnection connectAdmin(String theURL, Options theOptions) throws StardogException {
        try {
            URI aURI = new URI(theURL);
            if (aURI.getHost() == null) {
                throw new StardogException(theURL + " is an invalid connection string.");
            }
            int aPort = aURI.getPort() != -1 ? aURI.getPort() : 5820;
            ConnectionCredentials aCreds = null;
            Supplier aCredSupplier = (Supplier)theOptions.get(ConnectionConfiguration.CREDENTIALS_SUPPLIER);
            aCreds = aCredSupplier != null ? (ConnectionCredentials)aCredSupplier.get() : (ConnectionCredentials)theOptions.get(ConnectionConfiguration.CREDENTIALS);
            HttpAdminClientImpl aClient = aCreds != null ? new HttpAdminClientImpl(new URL(aURI.getScheme(), aURI.getHost(), aPort, "/admin"), theOptions, aCreds.getHttpCredentials()) : new HttpAdminClientImpl(new URL(aURI.getScheme(), aURI.getHost(), aPort, "/admin"), theOptions);
            aClient.connect();
            return new AdminConnectionImpl(theURL, aClient, this.mAdminConnectionViews, theOptions);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().equals("Connection refused")) {
                throw new StardogConnectionException("Connection refused: " + Strings2.withoutTrailingSlash((String)theURL), (Throwable)e);
            }
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean acceptsURL(String theURL) {
        return theURL.startsWith("http:") || theURL.startsWith("https:");
    }
}

