/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Change;
import com.complexible.common.base.ChangeList;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.impl.StreamStatementSources;
import com.complexible.common.rdf.query.PathQueryResult;
import com.complexible.common.rdf.query.SPARQLUtil;
import com.complexible.common.view.Views;
import com.complexible.stardog.CommitResult;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.TxInfo;
import com.complexible.stardog.api.BooleanQuery;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.ExplainOptions;
import com.complexible.stardog.api.Exporter;
import com.complexible.stardog.api.GraphQuery;
import com.complexible.stardog.api.LoginConnectionConfiguration;
import com.complexible.stardog.api.NamespacesInfo;
import com.complexible.stardog.api.PathQuery;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.api.ReadQuery;
import com.complexible.stardog.api.SelectPlanQuery;
import com.complexible.stardog.api.SelectQuery;
import com.complexible.stardog.api.UpdateQuery;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.AdminConnectionConfiguration;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.api.impl.BooleanQueryImpl;
import com.complexible.stardog.api.impl.ChangeCollector;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.complexible.stardog.api.impl.DatabaseNamespaces;
import com.complexible.stardog.api.impl.GraphQueryImpl;
import com.complexible.stardog.api.impl.PathQueryImpl;
import com.complexible.stardog.api.impl.SelectPlanQueryImpl;
import com.complexible.stardog.api.impl.SelectQueryImpl;
import com.complexible.stardog.api.impl.UpdateQueryImpl;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpClientImpl;
import com.complexible.stardog.protocols.http.client.HttpExporter;
import com.complexible.stardog.protocols.http.client.HttpGraphAliases;
import com.complexible.stardog.protocols.http.client.QueryRequest;
import com.complexible.stardog.query.AbstractGraphAliases;
import com.complexible.stardog.query.GraphAliases;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.stark.Statement;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.query.BooleanQueryResult;
import com.stardog.stark.query.GraphQueryResult;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.impl.BooleanQueryResultImpl;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hc.client5.http.auth.Credentials;

public final class HttpConnection
extends AbstractConnection
implements Connection {
    private final HttpClient mClient;
    private final String mServerURL;
    private AdminConnection mDBMS;
    private UUID mTxId;
    private boolean mNeedsRemoteBegin = false;
    private final Options mOptions;
    private final AtomicReference<HttpGraphAliases> mGraphAliases = new AtomicReference<Object>(null);

    private HttpConnection(String theServerURL, Views<Connection> theViews, HttpClient theClient, Options theOptions) throws StardogException {
        super((String)theOptions.get(ConnectionConfiguration.DATABASE), theViews, theOptions, StreamStatementSources.oneTime((Options)HttpConnection.getDefaultParserConfig((Options)theOptions)));
        this.mServerURL = theServerURL;
        this.mClient = theClient;
        this.mOptions = theOptions;
        this.mTxId = (UUID)theOptions.get(ConnectionConfiguration.TX);
    }

    static HttpConnection create(Views<Connection> theViews, URI theURI, String theUsername, String thePassphrase, Options theOptions) throws StardogException {
        try {
            HttpClientImpl aClient = new HttpClientImpl(theURI.toURL(), theOptions);
            Options aConnectionOpts = aClient.connect(theUsername, thePassphrase.toCharArray());
            return new HttpConnection(theURI.resolve("/").toString(), theViews, aClient, Options.combine((Options[])new Options[]{aConnectionOpts, theOptions}));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().equals("Connection refused")) {
                throw new StardogException("Connection refused: " + theURI.getHost() + ":" + theURI.getPort(), (Throwable)e);
            }
            throw Client.toStardogException(e);
        }
    }

    static HttpConnection create(Views<Connection> theViews, URI theURI, Credentials theCredentials, Options theOptions) throws StardogException {
        try {
            HttpClientImpl aClient = new HttpClientImpl(theURI.toURL(), theOptions);
            Options aConnectionOpts = aClient.connect(theCredentials);
            return new HttpConnection(theURI.resolve("/").toString(), theViews, aClient, Options.combine((Options[])new Options[]{aConnectionOpts, theOptions}));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().equals("Connection refused")) {
                throw new StardogException("Connection refused: " + theURI.getHost() + ":" + theURI.getPort(), (Throwable)e);
            }
            throw Client.toStardogException(e);
        }
    }

    public HttpClient getClient() {
        return this.mClient;
    }

    public Options getConnectionOptions() {
        return Options.unmodifiable((Options)this.mOptions);
    }

    public UUID getTxId() {
        return this.mTxId;
    }

    protected QueryRequest newQueryRequest(Query<?> theQuery) {
        return this.newQueryRequest(theQuery, Options.of((Option)ExplainOptions.VERBOSE, (Object)false, (Option)ExplainOptions.PROFILE, (Object)false));
    }

    protected QueryRequest newQueryRequest(Query<?> theQuery, Options theOptions) {
        return this.newQueryRequest(theQuery, theOptions, null);
    }

    protected QueryRequest newQueryRequest(Query<?> theQuery, FileFormat theFormat) {
        return this.newQueryRequest(theQuery, Options.of((Option)ExplainOptions.VERBOSE, (Object)false), theFormat);
    }

    protected QueryRequest newQueryRequest(Query<?> theQuery, Options theOptions, FileFormat theFormat) {
        long aLimit = -1L;
        long aOffset = -1L;
        if (theQuery instanceof ReadQuery) {
            ReadQuery aReadQuery = (ReadQuery)theQuery;
            aLimit = aReadQuery.limit();
            aOffset = aReadQuery.offset();
        }
        boolean aRefreshGA = !this.getOutstandingGraphAliases().isEmpty();
        this.markGraphAliasesUnchanged();
        return QueryRequest.newRequest(theQuery.queryString(), theQuery.baseURI()).id(theQuery.getID()).schema(theQuery.getSchema()).limit(aLimit).offset(aOffset).dataset(theQuery.dataset()).tx(this.mTxId).timeout(theQuery.timeout()).parameters(theQuery.parameters()).hints(theQuery.hints()).verbose(theOptions.is(ExplainOptions.VERBOSE)).profile(theOptions.is(ExplainOptions.PROFILE)).format(theFormat).refreshGraphAliases(aRefreshGA).build();
    }

    protected BooleanQueryResult _ask(BooleanQuery theQuery) {
        return new BooleanQueryResultImpl(this.mClient.ask(this.newQueryRequest((Query<?>)theQuery)));
    }

    protected GraphQueryResult _graph(GraphQuery theQuery) {
        return this.mClient.graph(this.newQueryRequest((Query<?>)theQuery));
    }

    protected PathQueryResult _paths(PathQuery theQuery) {
        return this.mClient.paths(this.newQueryRequest((Query<?>)theQuery));
    }

    protected InputStream _read(ReadQuery<?> theQuery, FileFormat theFormat) {
        return this.mClient.executeReadQuery(this.newQueryRequest((Query<?>)theQuery, theFormat));
    }

    protected void _update(UpdateQuery theQuery) {
        this.mClient.update(this.newQueryRequest((Query<?>)theQuery));
    }

    protected void cleanupPendingChanges(boolean theClose) {
        super.cleanupPendingChanges(true);
    }

    protected String explain(Query<?> theQuery, Options theOptions) {
        return this.mClient.explain(this.newQueryRequest(theQuery, theOptions));
    }

    protected SelectQueryResult _select(SelectQuery theQuery) {
        return this.mClient.select(this.newQueryRequest((Query<?>)theQuery));
    }

    protected SelectQueryResult _selectPlan(SelectPlanQuery theQuery) {
        return this.mClient.plan(this.newQueryRequest((Query<?>)theQuery));
    }

    public String toString() {
        return String.format("Connection{%s/%s}", this.mServerURL, this.name());
    }

    public boolean isStrictParsing() {
        return false;
    }

    public Exporter export() throws StardogException {
        return new HttpExporter(this);
    }

    public DataModel generateModel(DataModelFormat theInputFormat, Options theOptions) throws StardogException {
        return this.mClient.generateModel(theInputFormat, theOptions);
    }

    public AdminConnection admin() throws StardogException {
        if (this.mDBMS == null || !this.mDBMS.isOpen()) {
            Supplier aCredSupplier = (Supplier)this.mOptions.get(ConnectionConfiguration.CREDENTIALS_SUPPLIER);
            AdminConnectionConfiguration aCC = aCredSupplier == null ? this.setCredentials(AdminConnectionConfiguration.toServer((String)this.mServerURL)) : AdminConnectionConfiguration.toServer((String)this.mServerURL).credentialSupplier(aCredSupplier);
            this.mDBMS = aCC.connect();
        }
        return this.mDBMS;
    }

    private <C extends LoginConnectionConfiguration<?>> C setCredentials(C config) {
        this.setOption(config, ConnectionConfiguration.USERNAME);
        this.setOption(config, ConnectionConfiguration.PASSWORD);
        this.setOption(config, ConnectionConfiguration.IS_TOKEN);
        return config;
    }

    private <T> void setOption(LoginConnectionConfiguration<?> config, Option<T> option) {
        config.set(option, this.mOptions.get(option));
    }

    public NamespacesInfo namespaces() throws StardogException {
        return new DatabaseNamespaces(this.admin(), this.name());
    }

    public Collection<TxInfo> transactions() throws StardogException {
        return this.mClient.transactions(this.name());
    }

    public SelectQuery select(String theQuery, String theBase) throws StardogException {
        this.assertOpen();
        return new SelectQueryImpl((AbstractConnection)this, theQuery, theBase);
    }

    public SelectPlanQuery selectPlan(String theQuery, String theBase) throws StardogException {
        this.assertOpen();
        return new SelectPlanQueryImpl((AbstractConnection)this, theQuery, theBase);
    }

    public GraphQuery graph(String theQuery, String theBase) throws StardogException {
        this.assertOpen();
        return new GraphQueryImpl((AbstractConnection)this, theQuery, theBase);
    }

    public PathQuery paths(String theQuery, String theBase) throws StardogException {
        this.assertOpen();
        return new PathQueryImpl((AbstractConnection)this, theQuery, theBase);
    }

    public BooleanQuery ask(String theQuery, String theBase) throws StardogException {
        this.assertOpen();
        return new BooleanQueryImpl((AbstractConnection)this, theQuery, theBase);
    }

    public UpdateQuery update(String theQuery, String theBase) throws StardogException {
        this.assertOpen();
        return new UpdateQueryImpl((AbstractConnection)this, theQuery, theBase);
    }

    protected UUID _begin() throws StardogException {
        try {
            this.mTxId = UUID.randomUUID();
            this.mNeedsRemoteBegin = true;
        }
        catch (StardogException e) {
            throw Client.toStardogException((Exception)((Object)e));
        }
        return this.mTxId;
    }

    private void beginRemote() {
        if (this.mNeedsRemoteBegin) {
            this.mClient.begin(this.mTxId, this.getSchema());
            this.mNeedsRemoteBegin = false;
        }
    }

    protected void _rollback() throws StardogException {
        try {
            if (!this.mNeedsRemoteBegin) {
                this.mClient.rollback(this.mTxId);
            }
            this.ifGraphAliasesEnabled(AbstractGraphAliases::reset);
        }
        catch (StardogException e) {
            throw Client.toStardogException((Exception)((Object)e));
        }
    }

    public void cleanupTx(boolean theClose) {
        super.cleanupTx(theClose);
        this.mTxId = null;
        this.mNeedsRemoteBegin = false;
    }

    protected CommitResult _commit() throws StardogException {
        if (this.mNeedsRemoteBegin) {
            return new CommitResult(0L, 0L);
        }
        try {
            return this.mClient.commit(this.mTxId);
        }
        catch (StardogException e) {
            throw Client.toStardogException((Exception)((Object)e));
        }
    }

    public final boolean isOpen() throws IllegalStateException {
        return super.isOpen() && !this.mClient.isClosed();
    }

    protected void _close() throws StardogException {
        this.mClient.close();
        if (this.mDBMS != null) {
            this.mDBMS.close();
        }
    }

    protected CommitResult applyChanges(ChangeList<ConnectionChangeType, Object> theChanges, boolean doCommit) throws StardogException {
        try {
            Iterator aChange;
            if (theChanges.size() == 1 && !this.isReasoningEnabled() && (aChange = (Change)theChanges.iterator().next()).getChangeType() != ConnectionChangeType.RemoveWithPattern) {
                HttpClient.TxAction aAction = this.computeTxAction(this.mNeedsRemoteBegin, doCommit);
                this.mNeedsRemoteBegin = false;
                return this.mClient.applyChange(this.mTxId, (Change<ConnectionChangeType, Object>)aChange, aAction);
            }
            this.beginRemote();
            block5: for (Change aChange2 : theChanges) {
                switch ((ConnectionChangeType)aChange2.getChangeType()) {
                    case RemoveWithPattern: {
                        this.removeWithPattern((Statement)aChange2.getChange());
                        continue block5;
                    }
                }
                this.mClient.applyChange(this.mTxId, (Change<ConnectionChangeType, Object>)aChange2);
            }
            return doCommit ? this._commit() : null;
        }
        catch (StardogException e) {
            throw Client.toStardogException((Exception)((Object)e));
        }
    }

    private HttpClient.TxAction computeTxAction(boolean doBegin, boolean doCommit) {
        return doBegin ? (doCommit ? HttpClient.TxAction.BEGIN_AND_COMMIT : HttpClient.TxAction.BEGIN) : (doCommit ? HttpClient.TxAction.COMMIT : HttpClient.TxAction.NONE);
    }

    private void removeWithPattern(Statement theStmt) throws StardogException {
        this.mClient.update(QueryRequest.newRequest(SPARQLUtil.buildRemoveQuery((Statement)theStmt), "tag:stardog:api:").tx(this.mTxId).build());
    }

    public long size() throws StardogException {
        try {
            if (((Boolean)this.mOptions.get(ConnectionConfiguration.EXACT_SIZE)).booleanValue()) {
                this.pushOutstanding();
                return this.mClient.exactSize(this.mTxId);
            }
            return this.mClient.size();
        }
        catch (StardogException e) {
            throw Client.toStardogException((Exception)((Object)e));
        }
    }

    private <T> T ifGraphAliasesEnabled(Function<HttpGraphAliases, T> func, T dflt) {
        HttpGraphAliases ga = this.mGraphAliases.get();
        return ga == null ? dflt : func.apply(ga);
    }

    private void ifGraphAliasesEnabled(Consumer<HttpGraphAliases> action) {
        HttpGraphAliases ga = this.mGraphAliases.get();
        if (ga != null) {
            action.accept(ga);
        }
    }

    private List<Change<ConnectionChangeType, Object>> getOutstandingGraphAliases() {
        return this.ifGraphAliasesEnabled(HttpGraphAliases::getChanges, Collections.emptyList());
    }

    private void markGraphAliasesUnchanged() {
        this.ifGraphAliasesEnabled(HttpGraphAliases::markUnchanged);
    }

    public void pushOutstanding() throws StardogException {
        List<Change<ConnectionChangeType, Object>> gaChanges = this.getOutstandingGraphAliases();
        if (!gaChanges.isEmpty()) {
            this.assertInTransaction();
            gaChanges.forEach(arg_0 -> ((ChangeCollector)this.mCollector).apply(arg_0));
        }
        if (this.mTxId != null) {
            this.beginRemote();
            super.pushOutstanding();
        }
    }

    public Map<String, Object> currentStatus() throws StardogException {
        return this.getClient().status();
    }

    public GraphAliases graphAliases() {
        return (GraphAliases)this.mGraphAliases.updateAndGet(ga -> ga != null ? ga : new HttpGraphAliases(this));
    }
}

