/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Change;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.query.PathQueryResult;
import com.complexible.stardog.CommitResult;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.TxInfo;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.QueryRequest;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.query.GraphQueryResult;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public interface HttpClient
extends Client {
    public static final QueryResultFormat PREFERRED_TUPLE_FORMAT = QueryResultFormats.BINARY;
    public static final String CHARSET_DECLARATION = "; charset=utf-8";
    public static final Header PROTOCOL_VERSION_HEADER = new BasicHeader("SD-Protocol", (Object)String.valueOf(4));
    public static final Header ACCEPT_TUPLE_FORMAT_HEADER = new BasicHeader("Accept", (Object)PREFERRED_TUPLE_FORMAT.defaultMimeType());
    public static final Header ACCEPT_BOOLEAN_HEADER = new BasicHeader("Accept", (Object)"text/boolean");
    public static final Header ACCEPT_TRIG_HEADER = new BasicHeader("Accept", (Object)RDFFormats.TRIG.defaultMimeType());
    public static final Header ACCEPT_TURTLE_HEADER = new BasicHeader("Accept", (Object)RDFFormats.TURTLE.defaultMimeType());
    public static final Header ACCEPT_JSON_HEADER = new BasicHeader("Accept", (Object)"application/json");
    public static final Option<String> DATABASE = Option.create((String)"database");

    @Override
    public void close();

    public boolean isClosed();

    public boolean ask(QueryRequest var1) throws StardogException;

    public SelectQueryResult select(QueryRequest var1) throws StardogException;

    public SelectQueryResult plan(QueryRequest var1) throws StardogException;

    public void update(QueryRequest var1) throws StardogException;

    public GraphQueryResult graph(QueryRequest var1) throws StardogException;

    public PathQueryResult paths(QueryRequest var1) throws StardogException;

    public InputStream executeReadQuery(QueryRequest var1) throws StardogException;

    public CommitResult applyChange(UUID var1, Change<ConnectionChangeType, Object> var2, TxAction var3) throws StardogException;

    default public void applyChange(UUID theTxId, Change<ConnectionChangeType, Object> theChange) throws StardogException {
        this.applyChange(theTxId, theChange, TxAction.NONE);
    }

    public void begin(UUID var1, String var2) throws StardogException;

    public CommitResult commit(UUID var1) throws StardogException;

    public String explain(QueryRequest var1) throws StardogException;

    public void rollback(UUID var1) throws StardogException;

    public long size() throws StardogException;

    default public long exactSize() throws StardogException {
        return this.exactSize(null);
    }

    public long exactSize(UUID var1) throws StardogException;

    public void export(Collection<Resource> var1, RDFFormat var2, Iterable<Namespace> var3, OutputStream var4, File var5) throws StardogException;

    public String serverExport(Collection<Resource> var1, RDFFormat var2, File var3) throws StardogException;

    public DataModel generateModel(DataModelFormat var1, Options var2);

    public Map<String, Object> status() throws StardogException;

    public Collection<TxInfo> transactions(String var1);

    public static enum TxAction {
        NONE,
        BEGIN,
        COMMIT,
        BEGIN_AND_COMMIT;

    }
}

