/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.server.StardogConnectionException;
import java.net.ConnectException;
import javax.annotation.Nonnull;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;

public interface Client
extends AutoCloseable {
    @Override
    public void close();

    public Options connect(Credentials var1) throws StardogException;

    public Options connect(String var1, char[] var2) throws StardogException;

    public HttpContext context();

    public String url(String var1);

    public CloseableHttpResponse execute(ClassicHttpRequest var1);

    @Nonnull
    public static StardogException toStardogException(Exception theException) {
        return Client.toStardogException(null, theException);
    }

    @Nonnull
    public static StardogException toStardogException(String theMsg, Exception theException) {
        Throwable e;
        for (e = theException; e != null && !(e instanceof StardogException); e = e.getCause()) {
            if (e.getCause() instanceof StardogException) {
                return (StardogException)e.getCause();
            }
            if (e instanceof HttpHostConnectException) {
                return theMsg != null ? new StardogConnectionException(theMsg, e) : new StardogConnectionException(e);
            }
            if (!(e.getCause() instanceof ConnectException) && (e.getCause() == null || !e.getCause().getClass().getSimpleName().contains("HttpHostConnectException"))) continue;
            return theMsg != null ? new StardogConnectionException(theMsg, e.getCause()) : new StardogConnectionException(e.getCause());
        }
        if (e != null) {
            return (StardogException)e;
        }
        return theMsg != null ? new StardogException(theMsg, (Throwable)theException) : new StardogException((Throwable)theException);
    }
}

