/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.ErrorCodes;
import com.complexible.stardog.IndexErrorParser;
import com.complexible.stardog.StardogErrorParser;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.LoginConnectionConfiguration;
import com.complexible.stardog.pack.replication.ClusterErrorParser;
import com.complexible.stardog.protocols.http.admin.JsonOptionsObject;
import com.complexible.stardog.protocols.http.admin.JsonSerializableOptions;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.ClientSSLEngineSupplier;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpOptions;
import com.complexible.stardog.protocols.http.client.StackTrace;
import com.complexible.stardog.security.ResourceExistsException;
import com.complexible.stardog.security.ResourceNotFoundException;
import com.complexible.stardog.security.SecurityErrorParser;
import com.complexible.stardog.security.StardogAuthenticationException;
import com.complexible.stardog.security.StardogAuthorizationException;
import com.complexible.stardog.server.DatabaseErrorParser;
import com.complexible.stardog.server.DatabaseExistsException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stardog.ErrorCode;
import com.stardog.stark.Statement;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.query.MalformedQuery;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.KerberosConfig;
import org.apache.hc.client5.http.auth.KerberosCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.IdleConnectionEvictor;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.SPNegoSchemeFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHttpClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseHttpClient.class);
    private static final Function<JsonElement, String> STRING_CONVERTER = JsonElement::getAsString;
    private final Header acceptHeader = new BasicHeader("Accept", (Object)"application/json");
    private final Header acceptMultipartHeader = new BasicHeader("Accept", (Object)ContentType.MULTIPART_FORM_DATA.getMimeType());
    private final CloseableHttpClient mHttpClient;
    private final PoolingHttpClientConnectionManager mHttpConnManager;
    private final IdleConnectionEvictor mConnectionEvictor;
    private final HttpHost mHost;
    private final URL mURL;
    private boolean mClosed = false;
    private final Options mOptions;
    private HttpContext mContext;
    private static final Set<String> PARSEABLE_ERROR_CODES = ImmutableSet.builder().add((Object)DatabaseErrorParser.DatabaseErrorCode.OPERATION_NOT_SUPPORTED.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.DATABASE_EXISTS.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.QUERY_EXISTS.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.QUERY_NOT_FOUND.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.TRANSACTION_UNKNOWN.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.INVALID_DATABASE_NAME.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.DATABASE_UNKNOWN.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.MALFORMED_QUERY.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.INVALID_DATABASE_STATE.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.INVALID_CONFIGURATION.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.FUNCTION_EXISTS.getFormattedString()).add((Object)DatabaseErrorParser.DatabaseErrorCode.FUNCTION_NOT_FOUND.getFormattedString()).add((Object)IndexErrorParser.IndexErrorCode.WRITE_CONFLICT_EXCEPTION.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.AUTHENTICATION_EXCEPTION.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.AUTHORIZATION_EXCEPTION.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.SECURITY_RESOURCE_EXISTS.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.SECURITY_RESOURCE_IN_USE.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.SECURITY_RESOURCE_NOT_FOUND.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.SECURITY_RESOURCE_TYPE_INVALID.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.SECURITY_RESOURCE_NAME_INVALID.getFormattedString()).add((Object)SecurityErrorParser.SecurityErrorCode.ILLEGAL_PASSWORD.getFormattedString()).add((Object)ClusterErrorParser.ClusterErrorCode.NOT_IN_CLUSTER.getFormattedString()).add((Object)StardogErrorParser.GenericErrorCode.SHUTTING_DOWN.getFormattedString()).add((Object)StardogErrorParser.GenericErrorCode.PROCESS_EXISTS.getFormattedString()).add((Object)StardogErrorParser.GenericErrorCode.PROCESS_NOT_FOUND.getFormattedString()).add((Object)StardogErrorParser.GenericErrorCode.PROCESS_CANCELLED.getFormattedString()).build();

    public BaseHttpClient(URL theURL, Options theOptions, Credentials theCredentials) {
        DefaultClientTlsStrategy aFactory;
        this.mURL = theURL;
        this.mHost = new HttpHost(theURL.getProtocol(), theURL.getHost(), theURL.getPort());
        if (theURL.getProtocol().equals("https") && (System.getProperty("javax.net.ssl.trustStore") != null || System.getProperty("javax.net.ssl.keyStore") != null)) {
            try {
                aFactory = new DefaultClientTlsStrategy(new ClientSSLEngineSupplier().getCxt());
            }
            catch (SSLException e) {
                throw new StardogException((Throwable)e);
            }
        } else {
            aFactory = DefaultClientTlsStrategy.createDefault();
        }
        int customRetryCount = 3;
        String userRetryCount = System.getProperty("stardog.http.retryCount");
        if (userRetryCount != null) {
            customRetryCount = Integer.parseInt(userRetryCount);
        }
        int retryCount = customRetryCount;
        TimeValue connectionTTL = TimeValue.ofSeconds((long)10L);
        this.mHttpConnManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).setTcpNoDelay(true).build()).setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive(connectionTTL).build()).setMaxConnPerRoute(Math.max(10, (Integer)theOptions.get(HttpOptions.HTTP_MAX_CONNECTIONS) / 10)).setMaxConnTotal(((Integer)theOptions.get(HttpOptions.HTTP_MAX_CONNECTIONS)).intValue()).setTlsSocketStrategy((TlsSocketStrategy)aFactory).setConnPoolPolicy(PoolReusePolicy.FIFO).build();
        this.mHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.mHttpConnManager).setTargetAuthenticationStrategy((AuthenticationStrategy)new DefaultAuthenticationStrategy()).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(this, retryCount, TimeValue.ofSeconds((long)1L)){

            public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
                boolean retry = super.retryRequest(request, exception, execCount, context);
                if (retry) {
                    LOGGER.warn("IOException received from server ({}), will retry (tries: {})", (Object)exception.getMessage(), (Object)execCount);
                }
                return retry;
            }
        }).useSystemProperties().build();
        this.mOptions = theOptions;
        this.mConnectionEvictor = new IdleConnectionEvictor((ConnPoolControl)this.mHttpConnManager, null, TimeValue.ofSeconds((long)(connectionTTL.toSeconds() * 2L)), connectionTTL);
        this.mContext = theCredentials == null ? this.buildHttpContext((String)this.mOptions.get(ConnectionConfiguration.USERNAME), ((String)this.mOptions.get(ConnectionConfiguration.PASSWORD)).toCharArray()) : this.buildHttpContext(theCredentials);
        this.mConnectionEvictor.start();
    }

    public BaseHttpClient(URL theURL, Options theOptions) {
        this(theURL, theOptions, null);
    }

    Options getOptions() {
        return this.mOptions;
    }

    protected Options connect() {
        return Options.empty();
    }

    @Override
    public Options connect(String theUser, char[] thePW) throws StardogException {
        UsernamePasswordCredentials aCreds = new UsernamePasswordCredentials(theUser, thePW);
        return this.connect((Credentials)aCreds);
    }

    @Override
    public Options connect(Credentials theCredentials) throws StardogException {
        this.mContext = this.buildHttpContext(theCredentials);
        return this.connect();
    }

    @Override
    public HttpContext context() {
        return this.mContext;
    }

    @Override
    public String url(String theRelativePath) {
        String aExternalForm;
        return aExternalForm + ((aExternalForm = this.mURL.toExternalForm()).endsWith("/") || theRelativePath.startsWith("/") ? "" : "/") + theRelativePath;
    }

    protected void resetContext(String theUser, char[] thePW) {
        UsernamePasswordCredentials aCreds = new UsernamePasswordCredentials(theUser, thePW);
        this.resetContext((Credentials)aCreds);
    }

    protected void resetContext(Credentials theCredentials) {
        this.mContext = this.buildHttpContext(theCredentials);
    }

    private HttpContext buildHttpContext(String theUser, char[] thePW) {
        UsernamePasswordCredentials aCreds = new UsernamePasswordCredentials(theUser, thePW);
        return this.buildHttpContext((Credentials)aCreds);
    }

    protected HttpContext buildHttpContext(Credentials theCredentials) {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionKeepAlive(TimeValue.NEG_ONE_SECOND).setResponseTimeout(Timeout.DISABLED);
        if (!(theCredentials instanceof KerberosCredentials)) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme aAuthScheme = new BasicScheme();
            aAuthScheme.initPreemptive(theCredentials);
            authCache.put(this.mHost, (AuthScheme)aAuthScheme);
            context.setAuthCache((AuthCache)authCache);
        } else {
            boolean aAllowRDNS = (Boolean)this.mOptions.get(LoginConnectionConfiguration.KRB5_REVERSE_DNS);
            Registry authSchemeFactory = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(KerberosConfig.custom().setStripPort(KerberosConfig.Option.ENABLE).setUseCanonicalHostname(aAllowRDNS ? KerberosConfig.Option.ENABLE : KerberosConfig.Option.DISABLE).build(), (DnsResolver)SystemDefaultDnsResolver.INSTANCE)).build();
            context.setAuthSchemeRegistry((Lookup)authSchemeFactory);
            requestConfigBuilder.setTargetPreferredAuthSchemes(List.of("Negotiate"));
        }
        if (this.mOptions.get(ConnectionConfiguration.IS_TOKEN) == Boolean.TRUE) {
            ArrayList<BasicHeader> aHeaderList = new ArrayList<BasicHeader>();
            BasicHeader aBasicHeader = new BasicHeader("Authorization", (Object)String.format("%s %s", "bearer", this.mOptions.get(ConnectionConfiguration.PASSWORD)));
            aHeaderList.add(aBasicHeader);
            context.setAttribute("headers", aHeaderList);
        } else {
            AuthScope scope = new AuthScope(this.mHost.getHostName(), this.mHost.getPort());
            BasicCredentialsProvider aCredsProvider = new BasicCredentialsProvider();
            aCredsProvider.setCredentials(scope, theCredentials);
            context.setCredentialsProvider((CredentialsProvider)aCredsProvider);
        }
        context.setRequestConfig(requestConfigBuilder.build());
        return context;
    }

    public static void addProtocolHeaders(HttpMessage theMessage) {
        theMessage.addHeader(HttpClient.PROTOCOL_VERSION_HEADER);
    }

    public static void addConnectionStringParams(HttpMessage theMessage, Options theOptions) throws URISyntaxException {
        if (theMessage instanceof HttpUriRequestBase) {
            URIBuilder aBuilder = new URIBuilder(((HttpUriRequestBase)theMessage).getUri());
            List aQueryParams = aBuilder.getQueryParams();
            ArrayList aParams = Lists.newArrayListWithExpectedSize((int)aQueryParams.size());
            aQueryParams.stream().map(NameValuePair::getName).forEach(aParams::add);
            boolean aNewParam = false;
            for (Option anOption : theOptions) {
                Object aValue = theOptions.get(anOption);
                if (aValue == null || aParams.contains(anOption.toString())) continue;
                if (aValue instanceof Iterable) {
                    for (Object aObj : (Iterable)aValue) {
                        aBuilder.addParameter(anOption.toString(), aObj.toString());
                    }
                } else {
                    aBuilder.addParameter(anOption.toString(), aValue.toString());
                }
                aNewParam = true;
            }
            if (aNewParam) {
                try {
                    ((HttpUriRequestBase)theMessage).setUri(aBuilder.build());
                }
                catch (URISyntaxException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    @Override
    public synchronized CloseableHttpResponse execute(ClassicHttpRequest theRequest) {
        BaseHttpClient.addProtocolHeaders((HttpMessage)theRequest);
        if (this.mOptions.get(ConnectionConfiguration.RUN_AS_USER) != null) {
            theRequest.addHeader("SD-Run-As", this.mOptions.get(ConnectionConfiguration.RUN_AS_USER));
        }
        if (this.mOptions.get(ConnectionConfiguration.CONNECTION_TYPE) != null) {
            theRequest.addHeader("SD-Connection-Type", this.mOptions.get(ConnectionConfiguration.CONNECTION_TYPE));
        }
        CloseableHttpResponse aResponse = null;
        try {
            Object aRawHeader = this.mContext.getAttribute("headers");
            if (aRawHeader != null) {
                List aHeaders = (List)aRawHeader;
                aHeaders.forEach(arg_0 -> ((ClassicHttpRequest)theRequest).addHeader(arg_0));
            }
            aResponse = this.mHttpClient.execute(this.mHost, theRequest, this.mContext);
            BaseHttpClient.checkResponseCode(aResponse);
            return aResponse;
        }
        catch (Exception e) {
            ApacheHttp.HttpResponses.consumeQuietly(aResponse);
            throw Client.toStardogException(e);
        }
    }

    @Deprecated
    @VisibleForTesting
    public final CloseableHttpResponse executeRaw(ClassicHttpRequest theRequest, HttpContext theContext) throws IOException {
        return this.mHttpClient.execute(this.mHost, theRequest, theContext);
    }

    public static void checkResponseCode(CloseableHttpResponse theResponse) throws Exception {
        int statusCode = theResponse.getCode();
        if (statusCode >= 400) {
            try {
                String aMsg = theResponse.getReasonPhrase();
                boolean isJsonErrorMessage = false;
                Throwable aServerException = null;
                try {
                    if (theResponse.getEntity() != null) {
                        String aEntity = EntityUtils.toString((HttpEntity)theResponse.getEntity(), (Charset)Charsets.UTF_8).trim();
                        if (!Strings.isNullOrEmpty((String)aEntity)) {
                            aMsg = aEntity;
                        }
                        if (theResponse.getEntity().getContentType() != null && "application/json".equals(theResponse.getEntity().getContentType())) {
                            try {
                                JsonObject aObj = JsonParser.parseString((String)aEntity).getAsJsonObject();
                                aMsg = aObj.get("message").getAsString();
                                isJsonErrorMessage = !Strings.isNullOrEmpty((String)aMsg);
                                aServerException = BaseHttpClient.parseServerException(aObj, aMsg);
                            }
                            catch (Exception e) {
                                LOGGER.error("Unexpected error while parsing JSON", (Throwable)e);
                            }
                        }
                    }
                }
                catch (IOException aEntity) {
                    // empty catch block
                }
                Header aMsgHeader = theResponse.getLastHeader("Stardog-Error-Message");
                if (!isJsonErrorMessage && aMsgHeader != null) {
                    aMsg = aMsgHeader.getValue();
                }
                if (Strings.isNullOrEmpty((String)aMsg)) {
                    aMsg = "Unexpected server failure during execution.";
                }
                ErrorCode ec = null;
                try {
                    Header aHeader = theResponse.getLastHeader("SD-Error-Code");
                    if (aHeader != null) {
                        ec = ErrorCodes.parseCode((String)aHeader.getValue());
                    }
                }
                catch (IllegalArgumentException aHeader) {
                    // empty catch block
                }
                Throwable cause = null;
                if (ec != null) {
                    throw BaseHttpClient.errorCodeToException(ec, aServerException, aMsg, statusCode);
                }
                if (statusCode == 401) {
                    throw new StardogAuthenticationException(aMsg, cause);
                }
                if (statusCode == 403) {
                    throw new StardogAuthorizationException(aMsg, cause);
                }
                if (statusCode == 409) {
                    throw new DatabaseExistsException(aMsg, cause);
                }
                if (statusCode == 406) {
                    throw new ResourceExistsException(aMsg, cause);
                }
                if (statusCode == 404) {
                    throw new ResourceNotFoundException(aMsg, cause);
                }
                throw new HttpClientException(aMsg, theResponse.getCode(), cause);
            }
            catch (Throwable throwable) {
                ApacheHttp.HttpResponses.consume(theResponse);
                throw throwable;
            }
        }
    }

    static Throwable parseServerException(JsonObject theResponse, String theExceptionMessage) {
        String aExceptionStr;
        block11: {
            if (theResponse.has("stacktraceBinary")) {
                Throwable throwable;
                aExceptionStr = theResponse.get("stacktraceBinary").getAsString();
                byte[] bytes = BaseEncoding.base64().decode((CharSequence)aExceptionStr);
                ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
                ObjectInputStream in2 = new ObjectInputStream(bin);
                try {
                    throwable = (Throwable)in2.readObject();
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    catch (ClassNotFoundException in2) {
                        break block11;
                    }
                    catch (Exception e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Failed to parse server-side exception on the client side", (Throwable)e);
                            break block11;
                        }
                        LOGGER.warn("Failed to parse server-side exception on the client side: " + e.getMessage());
                    }
                }
                in2.close();
                return throwable;
            }
        }
        if (theResponse.has("stacktrace")) {
            aExceptionStr = theResponse.get("stacktrace").getAsString();
            return StackTrace.withStackTrace(theExceptionMessage, aExceptionStr);
        }
        return null;
    }

    static RuntimeException errorCodeToException(ErrorCode ec, Throwable theServerException, String message, int statusCode) {
        Throwable t;
        Throwable throwable = t = theServerException != null ? theServerException : ErrorCodes.parseToThrowable((ErrorCode)ec, (String)message);
        if (PARSEABLE_ERROR_CODES.contains(ec.getFormattedString())) {
            if (t instanceof RuntimeException) {
                return (RuntimeException)t;
            }
            return new StardogException(t);
        }
        if (ec == DatabaseErrorParser.DatabaseErrorCode.PARSE_EXCEPTION || ec == DatabaseErrorParser.DatabaseErrorCode.INVALID_QUERY_TYPE || ec == DatabaseErrorParser.DatabaseErrorCode.QUERY_NOT_FOUND) {
            return new StardogException((Throwable)new MalformedQuery(message, t));
        }
        return new HttpClientException(message, statusCode, t);
    }

    public static void onResponseEnd(CloseableHttpResponse response, boolean complete) {
        if (complete) {
            ApacheHttp.HttpResponses.consumeQuietly(response);
            RuntimeException errFromServer = BaseHttpClient.httpTrailersToException(ApacheHttp.HttpResponses.getHttpTrailers(response));
            if (errFromServer != null) {
                throw errFromServer;
            }
        }
        try {
            ApacheHttp.HttpResponses.close((HttpResponse)response);
        }
        catch (Exception e) {
            LOGGER.info("Exception closing the HTTP response", (Throwable)e);
        }
    }

    static RuntimeException httpTrailersToException(Header[] headers) {
        ErrorCode ec = null;
        String msg = "Unexpected server failure during query execution, check the server log for details";
        for (Header header : headers) {
            if (header.getName().equals("SD-Error-Code")) {
                ec = ErrorCodes.parseCode((String)header.getValue());
                continue;
            }
            if (!header.getName().equals("Stardog-Error-Message")) continue;
            msg = header.getValue();
        }
        if (ec == null) {
            return null;
        }
        return BaseHttpClient.errorCodeToException(ec, null, msg, 500);
    }

    @Override
    public final void close() {
        if (!this.mClosed) {
            this.mClosed = true;
            try {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
                autoCloseableArray[0] = () -> ((IdleConnectionEvictor)this.mConnectionEvictor).shutdown();
                autoCloseableArray[1] = this.mHttpClient;
                autoCloseableArray[2] = this.mHttpConnManager;
                AutoCloser.close((AutoCloseable[])autoCloseableArray);
            }
            catch (Exception e) {
                LOGGER.warn("There was an unexpected error closing the http client", (Throwable)e);
            }
        }
    }

    public final boolean isClosed() {
        return this.mClosed;
    }

    public static JsonObject parseResponseAsJsonObject(CloseableHttpResponse theResponse) throws StardogException {
        try {
            String aResult = EntityUtils.toString((HttpEntity)theResponse.getEntity(), (Charset)Charsets.UTF_8);
            return (JsonObject)new GsonBuilder().disableHtmlEscaping().create().fromJson(aResult, JsonElement.class);
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public static JsonArray parseResponseAsJsonArray(CloseableHttpResponse theResponse) throws StardogException {
        try {
            String aResult = EntityUtils.toString((HttpEntity)theResponse.getEntity(), (Charset)Charsets.UTF_8);
            return (JsonArray)new GsonBuilder().disableHtmlEscaping().create().fromJson(aResult, JsonElement.class);
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public static <T> T parseResponseAsObject(CloseableHttpResponse theResponse, Class<?> target) throws StardogException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(DeserializationFeature.USE_LONG_FOR_INTS);
            String aResult = EntityUtils.toString((HttpEntity)theResponse.getEntity(), (Charset)Charsets.UTF_8);
            return (T)objectMapper.readValue(aResult, objectMapper.getTypeFactory().constructType(Class.forName(target.getName())));
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    protected CloseableHttpResponse executeHttpGet(String thePath) throws StardogException {
        return this.executeHttpGet(thePath, this.acceptHeader);
    }

    protected CloseableHttpResponse executeHttpGet(String thePath, Header theHeader) throws StardogException {
        HttpGet aGet = new HttpGet(this.url(thePath));
        aGet.addHeader(theHeader);
        return this.execute((ClassicHttpRequest)aGet);
    }

    protected CloseableHttpResponse executeHttpGet(String thePath, List<Header> headers) throws StardogException {
        HttpGet aGet = new HttpGet(this.url(thePath));
        for (Header aHeader : headers) {
            aGet.addHeader(aHeader);
        }
        return this.execute((ClassicHttpRequest)aGet);
    }

    protected CloseableHttpResponse executeHttpPut(String thePath) throws StardogException {
        return this.executeHttpPut(thePath, null, null);
    }

    protected CloseableHttpResponse executeHttpPut(String thePath, JsonObject theJsonObj) throws StardogException {
        return this.executeHttpPut(thePath, theJsonObj.toString(), "application/json");
    }

    protected CloseableHttpResponse executeHttpPut(String thePath, String theEntity, String theMimeType) throws StardogException {
        return this.executeHttpPut(thePath, theEntity, theMimeType, new ArrayList<Header>());
    }

    protected CloseableHttpResponse executeHttpPut(String thePath, String theEntity, String theMimeType, List<Header> headers) throws StardogException {
        HttpPut aPut = new HttpPut(this.url(thePath));
        for (Header h : headers) {
            aPut.addHeader(h);
        }
        aPut.addHeader(this.acceptHeader);
        if (theEntity != null) {
            StringEntity aEntity = this.createStringEntity(theEntity, theMimeType);
            aPut.setEntity((HttpEntity)aEntity);
        }
        return this.execute((ClassicHttpRequest)aPut);
    }

    protected CloseableHttpResponse executeHttpPost(String thePath) throws StardogException {
        return this.executeHttpPost(thePath, null, null);
    }

    protected CloseableHttpResponse executeHttpPost(String thePath, JsonObject theJsonObj) throws StardogException {
        return this.executeHttpPost(thePath, theJsonObj.toString(), "application/json");
    }

    protected CloseableHttpResponse executeHttpPost(String thePath, String theEntity, String theMimeType) throws StardogException {
        HttpPost aPost = new HttpPost(this.url(thePath));
        aPost.addHeader(this.acceptHeader);
        if (theEntity != null) {
            StringEntity aEntity = this.createStringEntity(theEntity, theMimeType);
            aPost.setEntity((HttpEntity)aEntity);
        }
        return this.execute((ClassicHttpRequest)aPost);
    }

    protected StringEntity createStringEntity(String theEntity, String theMimeType) throws StardogException {
        String aMimeType = (String)MoreObjects.firstNonNull((Object)theMimeType, (Object)"text/plain");
        ContentType aContentType = ContentType.create((String)aMimeType, (Charset)Charsets.UTF_8);
        return new StringEntity(theEntity, aContentType);
    }

    protected CloseableHttpResponse executeHttpPostMultipart(String thePath, JsonObject theJsonObj, File[] theFiles) throws StardogException {
        HttpPost aPost = new HttpPost(this.url(thePath));
        aPost.addHeader(this.acceptHeader);
        if (theJsonObj != null && theFiles != null) {
            MultipartEntityBuilder aBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY);
            aBuilder.addPart("root", (ContentBody)new StringBody(theJsonObj.toString(), ContentType.APPLICATION_JSON));
            for (File aFile : theFiles) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("File: " + aFile.getName() + " [" + aFile.exists() + "]");
                }
                aBuilder.addPart(aFile.getName(), (ContentBody)new FileBody(aFile));
            }
            aPost.setEntity(aBuilder.build());
        }
        return this.execute((ClassicHttpRequest)aPost);
    }

    protected CloseableHttpResponse executeHttpPostMultipart(String thePath, LinkedHashMap<String, ContentBody> theParts) throws StardogException {
        HttpPost aPost = new HttpPost(this.url(thePath));
        aPost.addHeader(this.acceptMultipartHeader);
        MultipartEntityBuilder aBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY);
        theParts.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)aBuilder).addPart(arg_0, arg_1));
        HttpEntity entity = aBuilder.build();
        aPost.setEntity(entity);
        return this.execute((ClassicHttpRequest)aPost);
    }

    protected CloseableHttpResponse executeHttpDelete(String thePath) throws StardogException {
        HttpDelete aDel = new HttpDelete(this.url(thePath));
        aDel.addHeader(this.acceptHeader);
        return this.execute((ClassicHttpRequest)aDel);
    }

    protected static void consumeResponse(CloseableHttpResponse theResponse) throws StardogException {
        try {
            ApacheHttp.HttpResponses.consume(theResponse);
        }
        catch (IOException e) {
            throw new StardogException((Throwable)e);
        }
    }

    protected static String returnStringResponseFromMessage(CloseableHttpResponse theResponse) throws StardogException {
        try {
            String aString = ApacheHttp.Entities.toString(theResponse.getEntity());
            JsonObject aObj = (JsonObject)new GsonBuilder().disableHtmlEscaping().create().fromJson(aString, JsonElement.class);
            return aObj.get("message").getAsString();
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public static <T extends JsonOptionsObject> JsonSerializableOptions<T> parseResponseAsJson(CloseableHttpResponse theResponse, Class<T> theClass) throws StardogException {
        try {
            String aResult = ApacheHttp.Entities.toString(theResponse.getEntity());
            return new JsonSerializableOptions(aResult, theClass);
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }

    public static <T extends Collection<Statement>> T parseResponseAsRDF(CloseableHttpResponse theResponse, final T theCollection) throws StardogException {
        BaseHttpClient.parseResponseAsRDF(theResponse, (RDFHandler)new AbstractRDFHandler(){

            public void handle(@Nonnull Statement theStmt) {
                theCollection.add(theStmt);
            }
        });
        return theCollection;
    }

    public static void parseResponseAsRDF(CloseableHttpResponse theResponse, RDFHandler theHandler) throws StardogException {
        HttpEntity entity = theResponse.getEntity();
        String contentType = entity.getContentType();
        RDFFormat fmt = contentType == null ? RDFFormats.TURTLE : RDFFormats.forMime((String)contentType).orElse(RDFFormats.TURTLE);
        try (InputStream content = entity.getContent();){
            theHandler.start();
            RDFStreams.forStream((InputStream)content).format(fmt).parse(theHandler);
            theHandler.end();
        }
        catch (IOException e) {
            ApacheHttp.HttpResponses.consumeQuietly(theResponse);
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    protected static Collection<String> convertToStringCollection(JsonArray theArray) {
        return Lists.newArrayList((Iterator)Iterators.transform((Iterator)theArray.iterator(), STRING_CONVERTER));
    }

    public HttpHost getHost() {
        return this.mHost;
    }

    public static class HttpClientException
    extends StardogException {
        private final int mStatusCode;

        public HttpClientException(String theMessage, int theStatusCode, Throwable cause) {
            super(theMessage, cause);
            this.mStatusCode = theStatusCode;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }
    }
}

