/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.RDFFileSupplier;
import com.complexible.common.rdf.RDFStreamSupplier;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.RDFFileReference;
import com.complexible.common.rdf.impl.StatementIterationInputStream;
import com.complexible.common.rdf.impl.StreamStatementSource;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.protocols.http.FileReferenceOptions;
import com.complexible.stardog.protocols.http.JSON;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.io.WritingFailed;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttp {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheHttp.class);

    private ApacheHttp() {
        throw new AssertionError();
    }

    public static final class HttpResponses {
        private static final Header[] NO_TRAILERS = new Header[0];

        private HttpResponses() {
            throw new AssertionError();
        }

        public static void consume(CloseableHttpResponse theResponse) throws IOException {
            HttpEntity aEntity = theResponse.getEntity();
            if (aEntity != null) {
                EntityUtils.consume((HttpEntity)aEntity);
            }
            HttpResponses.close((HttpResponse)theResponse);
        }

        public static void close(HttpResponse theResponse) throws IOException {
            if (theResponse instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)theResponse).close(CloseMode.IMMEDIATE);
            }
        }

        public static void consumeQuietly(CloseableHttpResponse theResponse) {
            if (theResponse == null) {
                return;
            }
            HttpEntity aEntity = theResponse.getEntity();
            try {
                if (aEntity != null) {
                    EntityUtils.consumeQuietly((HttpEntity)aEntity);
                }
                HttpResponses.close((HttpResponse)theResponse);
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected error closing response", (Throwable)e);
            }
        }

        public static String toString(CloseableHttpResponse theResponse) throws IOException, ParseException {
            return HttpResponses.toString(theResponse, Charsets.UTF_8);
        }

        public static String toString(CloseableHttpResponse theResponse, Charset theCharset) throws IOException, ParseException {
            try {
                String string = EntityUtils.toString((HttpEntity)theResponse.getEntity(), (Charset)theCharset);
                return string;
            }
            finally {
                HttpResponses.close((HttpResponse)theResponse);
            }
        }

        public static long toLong(CloseableHttpResponse theResponse) throws IOException {
            try {
                long l = Entities.toLong(theResponse.getEntity());
                return l;
            }
            finally {
                HttpResponses.close((HttpResponse)theResponse);
            }
        }

        public static boolean toBoolean(CloseableHttpResponse theResponse) throws IOException, ParseException {
            try {
                boolean bl = Entities.toBoolean(theResponse.getEntity());
                return bl;
            }
            finally {
                HttpResponses.close((HttpResponse)theResponse);
            }
        }

        public static UUID toUUID(CloseableHttpResponse theResponse) throws IOException, ParseException {
            try {
                UUID uUID = Entities.toUUID(theResponse.getEntity());
                return uUID;
            }
            finally {
                HttpResponses.close((HttpResponse)theResponse);
            }
        }

        public static <T> T toObject(CloseableHttpResponse theResponse, Class<T> theType) throws IOException, ParseException {
            try {
                T t = Entities.toObject(theResponse.getEntity(), theType);
                return t;
            }
            finally {
                HttpResponses.close((HttpResponse)theResponse);
            }
        }

        public static <T> T toObject(CloseableHttpResponse theResponse, Type theType) throws IOException, ParseException {
            try {
                Object t = Entities.toObject(theResponse.getEntity(), theType);
                return t;
            }
            finally {
                HttpResponses.close((HttpResponse)theResponse);
            }
        }

        public static <T> T handleResponse(CloseableHttpResponse theResponse, Function<InputStream, T> theHandler) throws IOException {
            try {
                T t = theHandler.apply(theResponse.getEntity().getContent());
                return t;
            }
            finally {
                HttpResponses.close((HttpResponse)theResponse);
            }
        }

        public static Header[] getHttpTrailers(CloseableHttpResponse response) {
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isChunked()) {
                return NO_TRAILERS;
            }
            List headers = (List)entity.getTrailers().get();
            if (headers == null || headers.isEmpty()) {
                return NO_TRAILERS;
            }
            return headers.toArray(new Header[0]);
        }
    }

    public static final class HttpRequests {
        private HttpRequests() {
            throw new AssertionError();
        }

        public static void accept(HttpMessage theMessage, String theAccept) {
            Preconditions.checkNotNull((Object)theMessage);
            Preconditions.checkNotNull((Object)theAccept);
            theMessage.addHeader((Header)new BasicHeader("Accept", (Object)theAccept));
        }

        public static void appendURIParameter(HttpMessage message, String theParam, String theValue) {
            if (message instanceof HttpUriRequestBase) {
                try {
                    URIBuilder aBuilder = new URIBuilder(((HttpUriRequestBase)message).getUri());
                    aBuilder.addParameter(theParam, theValue);
                    ((HttpUriRequestBase)message).setUri(aBuilder.build());
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static class StatementSourceEntity
    extends AbstractHttpEntity {
        private final StatementSource mSource;
        private final RDFFormat mFormat;

        private StatementSourceEntity(StatementSource theSource, RDFFormat theFormat) {
            super(ContentType.create((String)theFormat.defaultMimeType(), (Charset)StandardCharsets.UTF_8), RDFFormats.compressionOf((RDFFormat)theFormat) == FileFormat.Compression.GZIP ? "gzip" : null);
            this.mSource = theSource;
            this.mFormat = theFormat;
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() {
            return new StatementIterationInputStream(this.mSource.statements(), this.mFormat);
        }

        public void writeTo(OutputStream theOutputStream) throws IOException {
            RDFWriter aWriter = (RDFWriter)RDFWriters.to((OutputStream)theOutputStream, (RDFFormat)this.mFormat).orElseThrow(() -> new IllegalArgumentException("Unsupported RDF format provided"));
            try {
                RDFStreams.parse((List)this.mSource.streams(), (RDFHandler)aWriter);
            }
            catch (WritingFailed e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public boolean isStreaming() {
            return this.mSource instanceof StreamStatementSource;
        }

        public void close() throws IOException {
            this.mSource.close();
        }
    }

    public static final class Entities {
        public static final String CHARSET_DECLARATION = "; charset=utf-8";

        private Entities() {
            throw new AssertionError();
        }

        public static long toLong(HttpEntity theEntity) throws IOException, NumberFormatException {
            try {
                long l = Long.parseLong(EntityUtils.toString((HttpEntity)theEntity, (Charset)Charsets.UTF_8));
                return l;
            }
            catch (NumberFormatException | ParseException e) {
                throw new NumberFormatException("Error parsing response as a long, " + e.getMessage());
            }
            finally {
                EntityUtils.consume((HttpEntity)theEntity);
            }
        }

        public static String toString(HttpEntity theEntity) throws IOException, ParseException {
            try {
                String string = EntityUtils.toString((HttpEntity)theEntity, (Charset)Charsets.UTF_8);
                return string;
            }
            finally {
                EntityUtils.consume((HttpEntity)theEntity);
            }
        }

        public static UUID toUUID(HttpEntity theEntity) throws IOException, ParseException {
            try {
                UUID uUID = UUID.fromString(EntityUtils.toString((HttpEntity)theEntity, (Charset)Charsets.UTF_8));
                return uUID;
            }
            finally {
                EntityUtils.consume((HttpEntity)theEntity);
            }
        }

        public static boolean toBoolean(HttpEntity theEntity) throws IOException, ParseException {
            try {
                boolean bl = Boolean.valueOf(EntityUtils.toString((HttpEntity)theEntity, (Charset)Charsets.UTF_8));
                return bl;
            }
            finally {
                EntityUtils.consume((HttpEntity)theEntity);
            }
        }

        public static <T> T toObject(HttpEntity theEntity, Class<T> theType) throws IOException, ParseException {
            try {
                Object object = JSON.fromJsonString((String)EntityUtils.toString((HttpEntity)theEntity, (Charset)Charsets.UTF_8), theType);
                return (T)object;
            }
            finally {
                EntityUtils.consume((HttpEntity)theEntity);
            }
        }

        public static <T> T toObject(HttpEntity theEntity, Type theType) throws IOException, ParseException {
            try {
                Object object = JSON.fromJsonString((String)EntityUtils.toString((HttpEntity)theEntity, (Charset)Charsets.UTF_8), (Type)theType);
                return (T)object;
            }
            finally {
                EntityUtils.consume((HttpEntity)theEntity);
            }
        }

        public static HttpEntity create(String theContent, ContentType theContentType) {
            Preconditions.checkNotNull((Object)theContent);
            Preconditions.checkNotNull((Object)theContentType);
            return new StringEntity(theContent, theContentType);
        }

        public static HttpEntity create(InputStream theStream, ContentType theContentType) {
            Preconditions.checkNotNull((Object)theStream);
            Preconditions.checkNotNull((Object)theContentType);
            return new BasicHttpEntity(theStream, theContentType);
        }

        public static HttpEntity create(StatementSource source, RDFFormat defaultFormat) {
            if (source instanceof RDFFileReference) {
                FileReferenceOptions aOpts = new FileReferenceOptions((RDFFileReference)source);
                return Entities.create(aOpts.toJsonString(), ContentType.APPLICATION_JSON);
            }
            if (source instanceof RDFStreamSupplier) {
                EntityBuilder builder = EntityBuilder.create();
                RDFStreamSupplier supplier = (RDFStreamSupplier)source;
                RDFFormat format = supplier.format();
                FileFormat.Compression compression = RDFFormats.compressionOf((RDFFormat)format);
                boolean aDecompressFirst = compression == FileFormat.Compression.ZIP || compression == FileFormat.Compression.BZIP2;
                try {
                    if (!aDecompressFirst) {
                        if (source instanceof RDFFileSupplier) {
                            return Entities.create(builder.setFile(((RDFFileSupplier)source).get().toFile()), format);
                        }
                        return Entities.create(builder.setStream(supplier.openStream()), format);
                    }
                }
                catch (IOException e) {
                    throw new StardogException((Throwable)e);
                }
            }
            return new StatementSourceEntity(source, defaultFormat);
        }

        private static HttpEntity create(EntityBuilder theEntityBuilder, RDFFormat theFormat) {
            boolean aGzip;
            theEntityBuilder.setContentType(ContentType.create((String)theFormat.defaultMimeType(), (Charset)StandardCharsets.UTF_8));
            FileFormat.Compression aCompression = RDFFormats.compressionOf((RDFFormat)theFormat);
            boolean bl = aGzip = aCompression == FileFormat.Compression.GZIP;
            if (aGzip) {
                theEntityBuilder.setContentEncoding("gzip");
            }
            return theEntityBuilder.build();
        }
    }

    public static final class Parameters {
        public static List<NameValuePair> params(Options theOptions) {
            ParameterListBuilder aBuilder = Parameters.builder();
            for (Option aOption : theOptions) {
                Object aValue = theOptions.get(aOption);
                if (aValue instanceof Iterable) {
                    for (Object aObj : (Iterable)aValue) {
                        aBuilder.parameter(aOption.toString(), aObj.toString());
                    }
                    continue;
                }
                aBuilder.parameter(aOption.toString(), aValue.toString());
            }
            return aBuilder.build();
        }

        public static List<NameValuePair> params(String theKey, String theValue) {
            return ImmutableList.of((Object)new BasicNameValuePair(theKey, theValue));
        }

        public static String format(String theKey, String theValue) {
            return Parameters.format(Parameters.params(theKey, theValue));
        }

        public static String format(List<NameValuePair> theParams) {
            return URLEncodedUtils.format(theParams, (Charset)Charsets.UTF_8);
        }

        public static ParameterListBuilder builder() {
            return new ParameterListBuilder();
        }

        public static class ParameterListBuilder {
            private ImmutableList.Builder<NameValuePair> mBuilder = ImmutableList.builder();

            public ParameterListBuilder parameter(String theKey, String theValue) {
                this.mBuilder.add((Object)new BasicNameValuePair(theKey, theValue));
                return this;
            }

            public ParameterListBuilder parameter(String theKey, boolean theValue) {
                return this.parameter(theKey, Boolean.toString(theValue));
            }

            public List<NameValuePair> build() {
                return this.mBuilder.build();
            }

            public URI uri(String theBase) {
                return URIs.uri(theBase, this.build());
            }

            public URI uri(URI theBase) {
                return URIs.uri(theBase.toASCIIString(), this.build());
            }

            public HttpEntity postBody() {
                return new StringEntity(URLEncodedUtils.format(this.build(), (Charset)Charsets.UTF_8), ContentType.APPLICATION_FORM_URLENCODED);
            }
        }
    }

    public static final class URIs {
        public static URI uri(String theBase, NameValuePair ... thePairs) {
            return URIs.uri(theBase, (List<? extends NameValuePair>)Lists.newArrayList((Object[])thePairs));
        }

        public static URI uri(URI theBase, List<? extends NameValuePair> thePairs) {
            return URIs.uri(theBase.toString(), thePairs);
        }

        public static URI uri(String theBase, List<? extends NameValuePair> thePairs) {
            return URI.create(theBase + (String)(thePairs != null && thePairs.size() > 0 ? "?" + URLEncodedUtils.format(thePairs, (Charset)Charsets.UTF_8) : ""));
        }
    }
}

