/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.license.util;

import com.stardog.license.util.Condition;
import com.stardog.license.util.JSONMethods;
import com.stardog.license.util.LicenseFlow;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LicensePrompt {
    private String mName;
    private List<Condition> mConditions;
    private String mText;
    private Class mType;
    private String mRegex;
    private List<Condition> mTerminateConditions;

    public LicensePrompt(String theName, String theText) {
        this.mName = theName;
        this.mText = theText;
        this.mConditions = new ArrayList<Condition>();
        this.mTerminateConditions = new ArrayList<Condition>();
        this.mType = String.class;
        this.mRegex = ".*";
    }

    public LicensePrompt(String theName, String theFormat, Object ... theArgs) {
        this.mName = theName;
        this.mText = String.format(theFormat, theArgs);
        this.mConditions = new ArrayList<Condition>();
        this.mTerminateConditions = new ArrayList<Condition>();
        this.mType = String.class;
        this.mRegex = ".*";
    }

    public String name() {
        return this.mName;
    }

    public LicensePrompt condition(Condition theCondition) {
        this.mConditions.add(theCondition);
        return this;
    }

    public LicensePrompt conditions(List<Condition> theConditions) {
        this.mConditions = theConditions;
        return this;
    }

    public List<Condition> terminateConditions() {
        return this.mTerminateConditions;
    }

    public LicensePrompt terminateCondition(Condition theCondition) {
        this.mTerminateConditions.add(theCondition);
        return this;
    }

    public LicensePrompt terminateConditions(List<Condition> theConditions) {
        this.mTerminateConditions = theConditions;
        return this;
    }

    public List<Condition> conditions() {
        return this.mConditions;
    }

    public String text() {
        return this.mText;
    }

    public LicensePrompt type(Class theType) {
        this.mType = theType;
        return this;
    }

    public Class type() {
        return this.mType;
    }

    public LicensePrompt regex(String theRegex) {
        this.mRegex = theRegex;
        return this;
    }

    public String regex() {
        return this.mRegex;
    }

    public LicenseFlow present(LicenseFlow theInitialFlow) {
        for (Condition c : this.mConditions) {
            if (c.test(theInitialFlow)) continue;
            return theInitialFlow;
        }
        Console aConsole = System.console();
        if (aConsole != null) {
            String aInput;
            do {
                if ((aInput = aConsole.readLine(theInitialFlow.convertVariables(this.mText) + "  ", new Object[0])).matches(this.mRegex)) continue;
                aConsole.writer().println(String.format("Invalid input; must match regex %s", this.mRegex));
            } while (!aInput.matches(this.mRegex));
            theInitialFlow.variable(this.mName, aInput);
            for (Condition c : this.mTerminateConditions) {
                if (!c.test(theInitialFlow)) continue;
                theInitialFlow.terminated(true);
            }
            return theInitialFlow;
        }
        return theInitialFlow;
    }

    public static LicensePrompt fromJson(JSONObject theJson) {
        try {
            ObjectInputStream ois;
            ByteArrayInputStream bais;
            LicensePrompt aPrompt = new LicensePrompt(theJson.getString("name"), theJson.getString("text"));
            try {
                aPrompt.type(Class.forName(theJson.getString("type")));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (theJson.has("conditions")) {
                for (Object c : JSONMethods.toList(theJson.getJSONArray("conditions"))) {
                    try {
                        bais = new ByteArrayInputStream(Base64.getDecoder().decode(c.toString().getBytes()));
                        try {
                            ois = new ObjectInputStream(bais);
                            try {
                                aPrompt.condition((Condition)ois.readObject());
                            }
                            finally {
                                ois.close();
                            }
                        }
                        finally {
                            bais.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (theJson.has("terminateConditions")) {
                for (Object c : JSONMethods.toList(theJson.getJSONArray("terminateConditions"))) {
                    try {
                        bais = new ByteArrayInputStream(Base64.getDecoder().decode(c.toString().getBytes()));
                        try {
                            ois = new ObjectInputStream(bais);
                            try {
                                aPrompt.terminateCondition((Condition)ois.readObject());
                            }
                            finally {
                                ois.close();
                            }
                        }
                        finally {
                            bais.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return aPrompt;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public JSONObject toJson() throws JSONException {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos;
        JSONObject aRet = new JSONObject();
        aRet.put("name", (Object)this.mName);
        aRet.put("text", (Object)this.mText);
        aRet.put("type", (Object)this.mType.getTypeName());
        aRet.put("regex", (Object)this.mRegex);
        try {
            baos = new ByteArrayOutputStream();
            try {
                oos = new ObjectOutputStream(baos);
                try {
                    JSONArray aConditions = new JSONArray();
                    for (Condition c : this.mConditions) {
                        oos.writeObject(c);
                        aConditions.put((Object)Base64.getEncoder().encodeToString(baos.toByteArray()));
                    }
                    aRet.put("conditions", (Object)aConditions);
                }
                finally {
                    oos.close();
                }
            }
            finally {
                baos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            baos = new ByteArrayOutputStream();
            try {
                oos = new ObjectOutputStream(baos);
                try {
                    JSONArray aTerminateConditions = new JSONArray();
                    for (Condition c : this.mTerminateConditions) {
                        oos.writeObject(c);
                        aTerminateConditions.put((Object)Base64.getEncoder().encodeToString(baos.toByteArray()));
                    }
                    aRet.put("terminateConditions", (Object)aTerminateConditions);
                }
                finally {
                    oos.close();
                }
            }
            finally {
                baos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aRet;
    }
}

