/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.complexible.stardog.index.BinaryCount;
import com.complexible.stardog.index.MutableBinaryCount;
import com.complexible.stardog.index.Quad;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Iterator;

public final class BinaryCounts {
    private static Function<Quad, BinaryCount> QUAD_TO_BINARY = new Function<Quad, BinaryCount>(){
        MutableBinaryCount mCount = BinaryCounts.mutable(0L, 0L, 1L, 0L);

        public BinaryCount apply(Quad theQuad) {
            this.mCount.setX(theQuad.getX());
            this.mCount.setY(theQuad.getY());
            this.mCount.setContext(theQuad.getContext());
            return this.mCount;
        }
    };

    public static Iterable<BinaryCount> from(Iterable<Quad> theQuads) {
        return Iterables.transform(theQuads, QUAD_TO_BINARY);
    }

    public static Iterator<BinaryCount> from(Iterator<Quad> theQuads) {
        return Iterators.transform(theQuads, QUAD_TO_BINARY);
    }

    public static MutableBinaryCount mutable(long theX, long theY, long theZ, long theContext) {
        return new MutableBinaryCountImpl(theX, theY, theZ, theContext);
    }

    public static MutableBinaryCount mutable(long theX, long theY, long theZ) {
        return new MutableBinaryCountImpl(theX, theY, theZ, -1L);
    }

    public static BinaryCount create(long theX, long theY, long theZ) {
        if (theY < Integer.MAX_VALUE) {
            boolean allInts = theZ > Integer.MIN_VALUE && theZ < Integer.MAX_VALUE && theX < Integer.MAX_VALUE;
            return allInts ? new IntNoContextBinaryCountImpl(theX, theY, theZ) : new IntPredicateNoContextBinaryCountImpl(theX, theY, theZ);
        }
        return new LongNoContextBinaryCountImpl(theX, theY, theZ);
    }

    public static BinaryCount create(long theX, long theY, long theCount, long theContext) {
        if (theContext == -1L) {
            return BinaryCounts.create(theX, theY, theCount);
        }
        if (theY < Integer.MAX_VALUE) {
            boolean allInts = theCount > Integer.MIN_VALUE && theCount < Integer.MAX_VALUE && theX < Integer.MAX_VALUE && theContext < Integer.MAX_VALUE;
            return allInts ? new IntBinaryCountImpl(theX, theY, theCount, Ints.checkedCast((long)theContext)) : new IntPredicateBinaryCountImpl(theX, theY, theCount, theContext);
        }
        return new LongBinaryCountImpl(theX, theY, theCount, theContext);
    }

    private static class MutableBinaryCountImpl
    implements MutableBinaryCount {
        private long mX;
        private long mY;
        private long mZ;
        private long mContext;

        public MutableBinaryCountImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = theX;
            this.mY = theY;
            this.mZ = theZ;
            this.mContext = theContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public void setX(long theX) {
            this.mX = theX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public void setY(long theY) {
            this.mY = theY;
        }

        @Override
        public final long getCount() {
            return this.mZ;
        }

        @Override
        public void setCount(long theZ) {
            this.mZ = theZ;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public void setContext(long theContext) {
            this.mContext = theContext;
        }

        @Override
        public final boolean hasContext() {
            return this.mContext != -1L;
        }

        @Override
        public int compareTo(BinaryCount o) {
            if (o == null) {
                return 1;
            }
            int comp = Longs.compare((long)this.getContext(), (long)o.getContext());
            if (comp == 0 && (comp = Longs.compare((long)this.getX(), (long)o.getX())) == 0) {
                comp = Longs.compare((long)this.getY(), (long)o.getY());
            }
            return comp;
        }

        @Override
        public MutableBinaryCountImpl copy() {
            return new MutableBinaryCountImpl(this.mX, this.mY, this.mZ, this.mContext);
        }

        public int hashCode() {
            return Longs.hashCode((long)this.mContext) >> 2 ^ Longs.hashCode((long)this.mX) >> 1 ^ Longs.hashCode((long)this.mY) ^ Longs.hashCode((long)this.mZ) << 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Quad) {
                Quad o = (Quad)obj;
                return this.mX == o.getX() && this.mY == o.getY() && this.mZ == o.getZ() && this.mContext == o.getContext();
            }
            if (obj instanceof BinaryCount) {
                BinaryCount oc = (BinaryCount)obj;
                return this.mX == oc.getX() && this.mY == oc.getY() && this.mZ == oc.getCount() && this.mContext == oc.getContext();
            }
            return false;
        }

        public String toString() {
            return "(" + this.getX() + ", " + this.getY() + "){" + this.getContext() + "}=" + this.getCount();
        }
    }

    private static class IntNoContextBinaryCountImpl
    extends AbstractBinaryCountImpl {
        private final int mX;
        private final int mY;
        private final int mZ;

        private IntNoContextBinaryCountImpl(long theX, long theY, long theZ) {
            this.mX = (int)theX;
            this.mY = (int)theY;
            this.mZ = (int)theZ;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getCount() {
            return this.mZ;
        }

        @Override
        public long getContext() {
            return -1L;
        }

        @Override
        public BinaryCount copy() {
            return new IntNoContextBinaryCountImpl(this.mX, this.mY, this.mZ);
        }
    }

    private static class IntPredicateNoContextBinaryCountImpl
    extends AbstractBinaryCountImpl {
        private final long mX;
        private final long mZ;
        private final int mY;

        private IntPredicateNoContextBinaryCountImpl(long theX, long theY, long theZ) {
            this.mX = theX;
            this.mY = (int)theY;
            this.mZ = theZ;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getCount() {
            return this.mZ;
        }

        @Override
        public long getContext() {
            return -1L;
        }

        @Override
        public BinaryCount copy() {
            return new IntPredicateNoContextBinaryCountImpl(this.mX, this.mY, this.mZ);
        }
    }

    private static class LongNoContextBinaryCountImpl
    extends AbstractBinaryCountImpl {
        private final long mX;
        private final long mY;
        private final long mZ;

        private LongNoContextBinaryCountImpl(long theX, long theY, long theZ) {
            this.mX = theX;
            this.mY = theY;
            this.mZ = theZ;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getCount() {
            return this.mZ;
        }

        @Override
        public long getContext() {
            return -1L;
        }

        @Override
        public BinaryCount copy() {
            return new LongNoContextBinaryCountImpl(this.mX, this.mY, this.mZ);
        }
    }

    private static class IntBinaryCountImpl
    extends AbstractBinaryCountImpl {
        private final int mX;
        private final int mY;
        private final int mZ;
        private final int mContext;

        private IntBinaryCountImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = (int)theX;
            this.mY = (int)theY;
            this.mZ = (int)theZ;
            this.mContext = (int)theContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getCount() {
            return this.mZ;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public BinaryCount copy() {
            return new IntBinaryCountImpl(this.mX, this.mY, this.mZ, this.mContext);
        }
    }

    private static class IntPredicateBinaryCountImpl
    extends AbstractBinaryCountImpl {
        private final long mX;
        private final long mZ;
        private final int mY;
        private final long mContext;

        private IntPredicateBinaryCountImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = theX;
            this.mY = (int)theY;
            this.mZ = theZ;
            this.mContext = theContext;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getCount() {
            return this.mZ;
        }

        @Override
        public BinaryCount copy() {
            return new IntPredicateBinaryCountImpl(this.mX, this.mY, this.mZ, this.mContext);
        }
    }

    private static class LongBinaryCountImpl
    extends AbstractBinaryCountImpl {
        private final long mX;
        private final long mY;
        private final long mZ;
        private final long mContext;

        private LongBinaryCountImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = theX;
            this.mY = theY;
            this.mZ = theZ;
            this.mContext = theContext;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getCount() {
            return this.mZ;
        }

        @Override
        public LongBinaryCountImpl copy() {
            return new LongBinaryCountImpl(this.mX, this.mY, this.mZ, this.mContext);
        }
    }

    private static abstract class AbstractBinaryCountImpl
    implements BinaryCount {
        private AbstractBinaryCountImpl() {
        }

        @Override
        public final boolean hasContext() {
            return this.getContext() != -1L;
        }

        @Override
        public int compareTo(BinaryCount o) {
            if (o == null) {
                return 1;
            }
            int comp = Longs.compare((long)this.getContext(), (long)o.getContext());
            if (comp == 0 && (comp = Longs.compare((long)this.getX(), (long)o.getX())) == 0) {
                comp = Longs.compare((long)this.getY(), (long)o.getY());
            }
            return comp;
        }

        public int hashCode() {
            return Longs.hashCode((long)this.getContext()) >> 2 ^ Longs.hashCode((long)this.getX()) >> 1 ^ Longs.hashCode((long)this.getY()) ^ Longs.hashCode((long)this.getCount()) << 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BinaryCount) {
                BinaryCount o = (BinaryCount)obj;
                return this.getX() == o.getX() && this.getY() == o.getY() && this.getCount() == o.getCount() && this.getContext() == o.getContext();
            }
            return false;
        }

        public String toString() {
            return "(" + this.getX() + ", " + this.getY() + "){" + this.getContext() + "}=" + this.getCount();
        }
    }
}

