/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.view;

import com.complexible.common.view.View;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

public final class Views<Input> {
    private final Set<? extends View<Input, ?>> mViews;

    Views(Set<? extends View<Input, ?>> theViews) {
        this.mViews = theViews;
    }

    public static <IView extends View<Input, ?>, Input> Views<Input> empty() {
        return Views.of(ImmutableSet.of());
    }

    public static <IView extends View<Input, ?>, Input> Views<Input> of(Set<IView> theViews) {
        return new Views<Input>(theViews);
    }

    public <Input, Output> Output as(Input theConn, Class<Output> theView) throws View.ViewException {
        Preconditions.checkNotNull(theConn, (Object)"Object cannot be null");
        Preconditions.checkNotNull(theView, (Object)"View cannot be null");
        for (View<Input, ?> aView : this.mViews) {
            if (!aView.canView(theConn, theView)) continue;
            return theView.cast(aView.as(theConn));
        }
        try {
            Constructor<Output> aConstructor = theView.getConstructor(theConn.getClass());
            return theView.cast(aConstructor.newInstance(this));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new View.ViewException(String.format("Cannot view %s as %s, appropriate implementation does not exist.", theConn.getClass().getName(), theView.getName()));
    }
}

