/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.version;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("([1-9]\\d*)\\.(\\d+)\\.(\\d+)((-([a-zA-Z0-9]+))*)");
    private int major;
    private int minor;
    private int patch;
    private String extra;

    public Version(String version) {
        Matcher stardogMatcher = SEMVER_PATTERN.matcher(version);
        if (!stardogMatcher.matches()) {
            throw new IllegalStateException("No match found for version " + version);
        }
        this.major = Integer.parseInt(stardogMatcher.group(1));
        this.minor = Integer.parseInt(stardogMatcher.group(2));
        this.patch = Integer.parseInt(stardogMatcher.group(3));
        this.extra = stardogMatcher.group(4);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setMajor(int theMajor) {
        this.major = theMajor;
    }

    public void setMinor(int theMinor) {
        this.minor = theMinor;
    }

    public void setPatch(int thePatch) {
        this.patch = thePatch;
    }

    public void setExtra(String theExtra) {
        this.extra = theExtra;
    }

    public String toString() {
        return String.format("%s.%s.%s%s", this.major, this.minor, this.patch, this.extra);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch && Objects.equals(this.extra, version.extra);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.extra);
    }

    @Override
    public int compareTo(Version o) {
        int c = Integer.compare(this.major, o.major);
        if (c == 0 && (c = Integer.compare(this.minor, o.minor)) == 0 && (c = Integer.compare(this.patch, o.patch)) == 0) {
            c = Strings.isNullOrEmpty((String)this.extra) ? (Strings.isNullOrEmpty((String)o.extra) ? 0 : 1) : (Strings.isNullOrEmpty((String)o.extra) ? -1 : this.extra.compareTo(o.extra));
        }
        return c;
    }
}

