/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util.concurrent.locks;

import com.carrotsearch.hppc.IntLongHashMap;
import com.carrotsearch.hppc.IntLongMap;
import com.complexible.common.base.Numbers;
import com.complexible.common.util.concurrent.locks.MultiLock;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreciseMultiLock
implements MultiLock {
    public static final Logger LOGGER = LoggerFactory.getLogger(PreciseMultiLock.class);
    private static final int LOCK_COUNT = 32;
    private static final int LOCK_MASK = 31;
    private final IntLongMap[] lockingThreads;
    private final Lock[] locks = new Lock[32];
    private final Condition[] conditions = new Condition[32];
    private long statsLocks;
    private long statsWaits;
    private long statsFails;

    public PreciseMultiLock() {
        this.lockingThreads = new IntLongMap[32];
        for (int i = 0; i < 32; ++i) {
            this.locks[i] = new ReentrantLock();
            this.conditions[i] = this.locks[i].newCondition();
            this.lockingThreads[i] = new IntLongHashMap();
        }
    }

    @Override
    public void lock(int lockID) {
        this.lock(lockID, true);
    }

    @Override
    public boolean tryLock(int lockID) {
        return this.lock(lockID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lock(int lockID, boolean waitIfLocked) {
        int lockIndex = lockID & 0x1F;
        Lock lock = this.locks[lockIndex];
        Condition condition = this.conditions[lockIndex];
        IntLongMap lockedIDs = this.lockingThreads[lockIndex];
        long currentThreadID = Thread.currentThread().getId();
        assert (currentThreadID != 0L);
        lock.lock();
        try {
            if (waitIfLocked) {
                while (lockedIDs.containsKey(lockID)) {
                    try {
                        ++this.statsWaits;
                        condition.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (lockedIDs.containsKey(lockID)) {
                ++this.statsFails;
                boolean bl = false;
                return bl;
            }
            ++this.statsLocks;
            long prevID = lockedIDs.put(lockID, currentThreadID);
            assert (prevID == 0L);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long heldBy(int lockID) {
        int lockIndex = lockID & 0x1F;
        Lock lock = this.locks[lockIndex];
        IntLongMap lockedIDs = this.lockingThreads[lockIndex];
        lock.lock();
        try {
            long l = lockedIDs.get(lockID);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(int lockID) throws IllegalArgumentException {
        int lockIndex = lockID & 0x1F;
        Lock lock = this.locks[lockIndex];
        Condition condition = this.conditions[lockIndex];
        IntLongMap lockedIDs = this.lockingThreads[lockIndex];
        long currentThreadID = Thread.currentThread().getId();
        lock.lock();
        try {
            Long lockingThreadID = lockedIDs.remove(lockID);
            if (lockingThreadID == null || lockingThreadID != currentThreadID) {
                throw new IllegalArgumentException(String.format("Thread %s cannot unlock %d (%s != %s)", Thread.currentThread().getName(), lockID, lockingThreadID, currentThreadID));
            }
            condition.signal();
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        return String.format("MultiLock[%d] (Locks: %s Waits: %s Fails: %s)", 32, Numbers.readable(this.statsLocks), Numbers.readable(this.statsWaits), Numbers.readable(this.statsFails));
    }
}

