/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util.concurrent;

import com.complexible.common.util.concurrent.Executors2;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Singleton
public final class SharedExecutor {
    private static final ExecutorService EXEC = Executors2.cachedThreadPoolBuilder().maxPoolSize(4096).rejectedExecutionHandler(new CallerRunsPolicy()).keepAlive(10L, TimeUnit.SECONDS).threadFactory(new ThreadFactoryBuilder().setPriority(5).setDaemon(false).setNameFormat("Stardog.Executor-%d").build()).build();

    public static void shutdown() {
        EXEC.shutdown();
        System.out.print("Waiting for running tasks to complete...");
        for (int waitTimes = 18; !EXEC.isTerminated() && waitTimes > 0; --waitTimes) {
            try {
                System.out.print(".");
                if (!EXEC.awaitTermination(10L, TimeUnit.SECONDS)) continue;
                System.out.println("done. Executor service has been shut down.");
                return;
            }
            catch (InterruptedException e) {
                System.err.println("interrupted. Unsafe shutdown might corrupt databases.");
                e.printStackTrace();
                break;
            }
        }
    }

    public static ExecutorService get() {
        return EXEC;
    }

    public static final class CallerRunsPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (e.isShutdown()) {
                throw new RejectedExecutionException("SharedExecutor has been shut down");
            }
            r.run();
        }
    }
}

