/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Executors2 {
    private Executors2() {
        throw new AssertionError();
    }

    public static CachedThreadPoolBuilder cachedThreadPoolBuilder() {
        return new CachedThreadPoolBuilder();
    }

    public static final class CachedThreadPoolBuilder {
        private int mCorePoolSize = 0;
        private int mMaxPoolSize = Integer.MAX_VALUE;
        private ThreadFactory mThreadFactory = Executors.defaultThreadFactory();
        private long mKeepAlive = 60L;
        private TimeUnit mTimeUnit = TimeUnit.SECONDS;
        private RejectedExecutionHandler mRejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();

        CachedThreadPoolBuilder() {
        }

        public CachedThreadPoolBuilder corePoolSize(int theCorePoolSize) {
            this.mCorePoolSize = theCorePoolSize;
            return this;
        }

        public CachedThreadPoolBuilder keepAlive(long theKeepAlive, TimeUnit theTimeUnit) {
            this.mKeepAlive = theKeepAlive;
            this.mTimeUnit = theTimeUnit;
            return this;
        }

        public CachedThreadPoolBuilder maxPoolSize(int theMaxPoolSize) {
            this.mMaxPoolSize = theMaxPoolSize;
            return this;
        }

        public CachedThreadPoolBuilder rejectedExecutionHandler(RejectedExecutionHandler theRejectedExecutionHandler) {
            this.mRejectedExecutionHandler = theRejectedExecutionHandler;
            return this;
        }

        public CachedThreadPoolBuilder threadFactory(ThreadFactory theThreadFactory) {
            this.mThreadFactory = theThreadFactory;
            return this;
        }

        public CachedThreadPoolBuilder callerRuns() {
            return this.rejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        }

        public CachedThreadPoolBuilder abort() {
            return this.rejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        }

        public CachedThreadPoolBuilder discard() {
            return this.rejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        }

        public CachedThreadPoolBuilder discardOldest() {
            return this.rejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        }

        public ThreadPoolExecutor build() {
            return this.build(new SynchronousQueue<Runnable>());
        }

        public ThreadPoolExecutor build(BlockingQueue<Runnable> theWorkQueue) {
            return new ThreadPoolExecutor(this.mCorePoolSize, this.mMaxPoolSize, this.mKeepAlive, this.mTimeUnit, theWorkQueue, this.mThreadFactory, this.mRejectedExecutionHandler);
        }

        public ScheduledThreadPoolExecutor buildScheduled() {
            return new ScheduledThreadPoolExecutor(this.mCorePoolSize, this.mThreadFactory, this.mRejectedExecutionHandler);
        }
    }
}

