/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util.concurrent;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ExecutionGroup {
    public ExecutionGroup add(Callable<?> theTask) {
        this.performAdd(theTask);
        return this;
    }

    public ExecutionGroup addAll(Iterator<Callable<?>> theTasks) {
        while (theTasks.hasNext()) {
            this.performAdd(theTasks.next());
        }
        return this;
    }

    public ExecutionGroup addAll(Iterable<Callable<?>> theTasks) {
        for (Callable<?> aTask : theTasks) {
            this.performAdd(aTask);
        }
        return this;
    }

    protected abstract void performAdd(Callable<?> var1);

    public abstract void executeAndWait() throws ExecutionException, InterruptedException;

    public abstract Iterable<Future<?>> execute() throws ExecutionException, InterruptedException;

    public abstract boolean isExecuting();

    public static ExecutionGroup concurrent(final ExecutorService theExecutorService) {
        return new ExecutionGroup(){
            private final BlockingQueue<Future<?>> mFutures = new LinkedBlockingQueue();

            @Override
            public Iterable<Future<?>> execute() {
                return this.mFutures;
            }

            @Override
            public void executeAndWait() throws ExecutionException, InterruptedException {
                Future aFuture;
                AtomicReference<Exception> aException = new AtomicReference<Exception>();
                while ((aFuture = (Future)this.mFutures.poll()) != null) {
                    try {
                        aFuture.get();
                    }
                    catch (InterruptedException ie) {
                        aFuture.cancel(true);
                        this.mFutures.forEach(f -> f.cancel(true));
                        this.addSuppressed(aException, ie);
                    }
                    catch (Exception e) {
                        this.addSuppressed(aException, e);
                    }
                }
                Exception err = (Exception)aException.get();
                if (err != null) {
                    Throwables.throwIfInstanceOf((Throwable)err, ExecutionException.class);
                    Throwables.throwIfInstanceOf((Throwable)err, InterruptedException.class);
                    Throwables.throwIfUnchecked((Throwable)err);
                    throw new RuntimeException(err);
                }
            }

            private void addSuppressed(AtomicReference<Exception> theBase, Exception theNext) {
                if (!theBase.compareAndSet(null, theNext)) {
                    theBase.get().addSuppressed(theNext);
                }
            }

            @Override
            protected void performAdd(Callable<?> theTask) {
                this.mFutures.add(theExecutorService.submit(theTask));
            }

            @Override
            public boolean isExecuting() {
                return !this.mFutures.isEmpty();
            }
        };
    }

    public static ExecutionGroup sequential() {
        return new ExecutionGroup(){
            private final BlockingQueue<Callable<?>> mTasks = new LinkedBlockingQueue();

            @Override
            public Iterable<Future<?>> execute() {
                ArrayList aFutures = Lists.newArrayList();
                for (Callable callable : this.mTasks) {
                    aFutures.add(new FutureTask(callable));
                }
                return aFutures;
            }

            @Override
            public void executeAndWait() throws ExecutionException, InterruptedException {
                Exception aException = null;
                while (true) {
                    try {
                        Callable aTask;
                        while ((aTask = (Callable)this.mTasks.poll()) != null) {
                            aTask.call();
                        }
                    }
                    catch (Exception e) {
                        aException = e;
                        continue;
                    }
                    break;
                }
                if (aException != null) {
                    Throwables.throwIfInstanceOf((Throwable)aException, ExecutionException.class);
                    Throwables.throwIfInstanceOf((Throwable)aException, InterruptedException.class);
                    Throwables.throwIfInstanceOf((Throwable)aException, RuntimeException.class);
                    throw new RuntimeException(aException);
                }
            }

            @Override
            protected void performAdd(Callable<?> theTask) {
                this.mTasks.add(theTask);
            }

            @Override
            public boolean isExecuting() {
                return !this.mTasks.isEmpty();
            }
        };
    }
}

