/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public final class StackTrace {
    private final List<StackTraceElement> elements;
    private List<StackTraceElement> elementsFilteredForEquality = null;

    public StackTrace() {
        this(Integer.MAX_VALUE, 2);
    }

    public StackTrace(int maxElementCount) {
        this(maxElementCount, 2);
    }

    private StackTrace(int maxElementCount, int elementsToIgnore) {
        Exception exception = new Exception();
        StackTraceElement[] allElements = exception.getStackTrace();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = elementsToIgnore; i < maxElementCount + elementsToIgnore + 1 && i < allElements.length; ++i) {
            builder.add((Object)allElements[i]);
        }
        this.elements = builder.build();
    }

    private List<StackTraceElement> generateStackForEquality() {
        if (this.elementsFilteredForEquality == null) {
            this.elementsFilteredForEquality = ImmutableList.copyOf((Iterable)Iterables.filter(this.elements, element -> element.getLineNumber() > 0));
        }
        return this.elementsFilteredForEquality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackTrace)) {
            return false;
        }
        StackTrace rhs = (StackTrace)o;
        return this.generateStackForEquality().equals(rhs.generateStackForEquality());
    }

    public int hashCode() {
        return this.generateStackForEquality().hashCode();
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        for (StackTraceElement methodCall : this.elements) {
            msg.append("\t").append(methodCall).append("\n");
        }
        return msg.toString();
    }
}

