/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class ListenerSupport<T extends EventListener>
implements Iterable<T> {
    private final CopyOnWriteArrayList<T> mListeners = new CopyOnWriteArrayList();

    public void addListener(T theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.add(theListener);
        }
    }

    public void removeListener(T theListener) {
        this.mListeners.remove(theListener);
    }

    private Collection<T> getListeners() {
        return Collections.unmodifiableCollection(this.mListeners);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.mListeners.forEach((Consumer<T>)action);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.getListeners().iterator();
    }

    public static <T extends EventListener> ListenerSupport<T> create() {
        return new ListenerSupport<T>();
    }
}

