/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Ordering;
import java.math.BigInteger;
import java.util.Comparator;

public class AlphaNumericComparator<T>
implements Comparator<T> {
    @Deprecated
    public static final AlphaNumericComparator<Object> CASE_SENSITIVE = new AlphaNumericComparator(true);
    @Deprecated
    public static final AlphaNumericComparator<Object> CASE_INSENSITIVE = new AlphaNumericComparator(false);
    private static final CharMatcher DIGIT = CharMatcher.digit();
    private static final CharMatcher NON_DIGIT = CharMatcher.digit().negate();
    private final Comparator<String> comparator;

    public static <T> AlphaNumericComparator<T> caseSensitive() {
        return CASE_SENSITIVE;
    }

    public static <T> AlphaNumericComparator<T> caseInsensitive() {
        return CASE_INSENSITIVE;
    }

    public static <T> AlphaNumericComparator<T> getInstance(boolean caseSensitive) {
        return caseSensitive ? AlphaNumericComparator.caseInsensitive() : AlphaNumericComparator.caseInsensitive();
    }

    private AlphaNumericComparator(boolean caseSensitive) {
        this.comparator = caseSensitive ? Ordering.natural() : String.CASE_INSENSITIVE_ORDER;
    }

    private int findMatch(CharMatcher matcher, String str, int start) {
        int index = matcher.indexIn((CharSequence)str, start);
        return index != -1 ? index : str.length();
    }

    @Override
    public int compare(T o1, T o2) {
        String str1 = o1.toString();
        String str2 = o2.toString();
        int length1 = str1.length();
        int length2 = str2.length();
        int index1 = 0;
        int index2 = 0;
        int cmp = this.comparator.compare(str1, str2);
        if (cmp == 0) {
            return cmp;
        }
        boolean numericPhase = false;
        while (index1 < length1 && index2 < length2) {
            CharMatcher matcher = numericPhase ? NON_DIGIT : DIGIT;
            int end1 = this.findMatch(matcher, str1, index1);
            int end2 = this.findMatch(matcher, str2, index2);
            String sub1 = str1.substring(index1, end1);
            String sub2 = str2.substring(index2, end2);
            if (numericPhase) {
                BigInteger n1 = new BigInteger(sub1);
                BigInteger n2 = new BigInteger(sub2);
                cmp = n1.compareTo(n2);
            } else {
                cmp = this.comparator.compare(sub1, sub2);
            }
            if (cmp != 0) {
                return cmp;
            }
            index1 = end1;
            index2 = end2;
            numericPhase = !numericPhase;
        }
        return index1 == length1 && index2 == length2 ? 0 : this.comparator.compare(str1.substring(index1), str2.substring(index2));
    }
}

