/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.trie;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.complexible.common.trie.Node;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public abstract class PrefixTree<T> {
    public abstract Node<T> getRoot();

    public abstract boolean put(long[] var1, T var2);

    public abstract T get(long[] var1);

    protected long[] normalize(long[] key) {
        Arrays.sort(key);
        return key;
    }

    public Collection<T> getAllMatchingValues(long[] key) {
        Collection<Node<T>> aFrontier = this.getMatchingStartNodes(key);
        ArrayList aMatchingValues = Lists.newArrayList();
        for (Node<T> aNode : aFrontier) {
            this.traverse(aNode, aMatchingValues);
        }
        return aMatchingValues;
    }

    public void traverse(Node<T> start, Collection<T> terminals) {
        Node next;
        Set<Node<T>> visited = null;
        ArrayDeque todo = Queues.newArrayDeque();
        todo.add(start);
        while ((next = (Node)todo.poll()) != null) {
            if (this.markVisited(visited, next)) {
                if (next.isObjectNode()) {
                    T value = this.getValue(next);
                    assert (value != null);
                    terminals.add(value);
                }
                for (LongObjectCursor cursor : next.getChildren()) {
                    todo.add((Node)cursor.value);
                }
                continue;
            }
            assert (false) : "A cycle is detected in a trie";
        }
    }

    public T getValue(Node<T> node) {
        return node.getValue();
    }

    public abstract Collection<Node<T>> getMatchingStartNodes(long[] var1);

    public abstract void visitMinSupersets(long[] var1, Consumer<Node<T>> var2);

    public abstract void visitMaxSubsets(long[] var1, Consumer<Node<T>> var2);

    public void clear() {
        this.getRoot().clear();
    }

    boolean markVisited(Set<Node<T>> visited, Node<T> next) {
        return visited == null || visited.add(next);
    }

    public abstract long size();

    public abstract long nodes();

    public List<T> values() {
        ArrayList values = Lists.newArrayList();
        this.traverse(this.getRoot(), values);
        assert ((long)values.size() == this.size());
        return values;
    }

    public abstract void print(Writer var1) throws IOException;

    protected void indent(int size, Writer writer) throws IOException {
        for (int i = 0; i < size; ++i) {
            writer.write("\t");
        }
    }
}

