/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.timer;

public enum DurationFormat {
    FULL("%d hour(s) %d minute(s) %d second(s) %d milliseconds(s)", true),
    LONG("%02d:%02d:%02d.%03d", true),
    MEDIUM("%02d:%02d.%03d", false),
    SHORT("%2$02d:%3$02d", false);

    private final String formatString;
    private final boolean hoursVisible;

    private DurationFormat(String formatString, boolean hoursVisible) {
        this.formatString = formatString;
        this.hoursVisible = hoursVisible;
    }

    public String format(long durationInMilliseconds) {
        long hours;
        if (this.hoursVisible) {
            hours = durationInMilliseconds / 3600000L;
            durationInMilliseconds -= hours * 3600000L;
        } else {
            hours = 0L;
        }
        long minutes = durationInMilliseconds / 60000L;
        long seconds = (durationInMilliseconds -= minutes * 60000L) / 1000L;
        long milliseconds = durationInMilliseconds - seconds * 1000L;
        return this.hoursVisible ? String.format(this.formatString, hours, minutes, seconds, milliseconds) : String.format(this.formatString, minutes, seconds, milliseconds);
    }
}

