/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.stream;

import com.complexible.common.util.concurrent.SharedForkJoinExecutor;
import java.util.Spliterator;
import java.util.concurrent.CountedCompleter;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;

public final class ForEachIntTask
extends CountedCompleter<Void> {
    private final IntConsumer mConsumer;
    private final BooleanSupplier mCancellationFlag;
    private long mTargetSize;
    private Spliterator.OfInt mSpliterator;
    private static final int LEAF_TARGET = SharedForkJoinExecutor.CONCURRENCY_LEVEL;

    public ForEachIntTask(Spliterator.OfInt theSpliterator, BooleanSupplier theCancellationFlag, IntConsumer theConsumer) {
        super(null);
        this.mTargetSize = 0L;
        this.mConsumer = theConsumer;
        this.mSpliterator = theSpliterator;
        this.mCancellationFlag = theCancellationFlag;
    }

    private ForEachIntTask(ForEachIntTask theParent, Spliterator.OfInt theSpliterator, BooleanSupplier theCancellationFlag, IntConsumer theConsumer) {
        super(theParent);
        this.mConsumer = theConsumer;
        this.mSpliterator = theSpliterator;
        this.mTargetSize = theParent.mTargetSize;
        this.mCancellationFlag = theCancellationFlag;
    }

    private static long suggestTargetSize(long theSizeEstimate) {
        long aEst = theSizeEstimate / (long)LEAF_TARGET;
        return aEst > 0L ? aEst : 1L;
    }

    @Override
    public void compute() {
        Spliterator.OfInt aRightSplit = this.mSpliterator;
        long aSizeEstimate = aRightSplit.estimateSize();
        long aSizeThreshold = this.mTargetSize;
        if (aSizeThreshold == 0L) {
            this.mTargetSize = aSizeThreshold = ForEachIntTask.suggestTargetSize(aSizeEstimate);
        }
        boolean aForkRight = false;
        ForEachIntTask aTask = this;
        while (!this.mCancellationFlag.getAsBoolean()) {
            ForEachIntTask aTaskToFork;
            Spliterator.OfInt aLeftSplit;
            if (aSizeEstimate <= aSizeThreshold || (aLeftSplit = aRightSplit.trySplit()) == null) {
                while (!this.mCancellationFlag.getAsBoolean() && aRightSplit.tryAdvance(this.mConsumer)) {
                }
                break;
            }
            ForEachIntTask aLeftTask = new ForEachIntTask(aTask, aLeftSplit, this.mCancellationFlag, this.mConsumer);
            aTask.addToPendingCount(1);
            if (aForkRight) {
                aForkRight = false;
                aRightSplit = aLeftSplit;
                aTaskToFork = aTask;
                aTask = aLeftTask;
            } else {
                aForkRight = true;
                aTaskToFork = aLeftTask;
            }
            aTaskToFork.fork();
            aSizeEstimate = aRightSplit.estimateSize();
        }
        aTask.mSpliterator = null;
        aTask.propagateCompletion();
    }
}

