/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.primitives;

import com.complexible.common.primitives.AbstractLongIterator;
import com.complexible.common.primitives.CloseableLongIterator;
import com.complexible.common.primitives.ResettableLongIterator;

public class ConstantAppendingLongIterator
extends AbstractLongIterator {
    private final CloseableLongIterator mIterator;
    private final long mConstant;
    private boolean mConstantReturned;

    public ConstantAppendingLongIterator(CloseableLongIterator theIterator, long theConstant) {
        this.mIterator = theIterator;
        this.mConstant = theConstant;
        this.mConstantReturned = false;
    }

    @Override
    protected long computeNext() {
        if (this.mIterator.hasNext()) {
            long aNext = this.mIterator.next();
            this.mConstantReturned |= aNext == this.mConstant;
            return aNext;
        }
        if (!this.mConstantReturned) {
            this.mConstantReturned = true;
            return this.mConstant;
        }
        return this.endOfData();
    }

    @Override
    public void close() {
        this.mIterator.close();
    }

    @Override
    protected void performReset() {
        if (this.mIterator instanceof ResettableLongIterator) {
            ((ResettableLongIterator)((Object)this.mIterator)).reset();
        }
    }
}

