/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.primitives;

import com.complexible.common.collect.PeekingLongIterator;
import com.complexible.common.primitives.CloseableLongIterator;
import com.complexible.common.primitives.ResettableLongIterator;
import java.util.NoSuchElementException;

public abstract class AbstractLongIterator
implements ResettableLongIterator,
PeekingLongIterator,
CloseableLongIterator {
    protected long mNext;

    protected AbstractLongIterator() {
        this.mNext = Long.MIN_VALUE;
    }

    protected AbstractLongIterator(long theFirst) {
        this.mNext = theFirst;
    }

    @Override
    public final void reset() {
        this.mNext = Long.MIN_VALUE;
        this.performReset();
    }

    @Override
    public boolean hasNext() {
        if (this.mNext != Long.MIN_VALUE) {
            return true;
        }
        this.mNext = this.computeNext();
        return this.mNext != Long.MIN_VALUE;
    }

    @Override
    public final long next() {
        if (this.hasNext()) {
            return this.consumeNext();
        }
        throw new NoSuchElementException();
    }

    @Override
    public final long peek() {
        if (this.hasNext()) {
            return this.mNext;
        }
        throw new NoSuchElementException();
    }

    long consumeNext() {
        long aTmp = this.mNext;
        this.mNext = Long.MIN_VALUE;
        return aTmp;
    }

    protected final long endOfData() {
        return Long.MIN_VALUE;
    }

    protected abstract long computeNext();

    protected abstract void performReset();
}

