/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.pool;

import com.complexible.common.pool.Pool;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.impl.GenericObjectPool;

public abstract class PoolConfig<T, E extends Exception> {
    protected int mMinPool = 0;
    protected final GenericObjectPool.Config mConfig = new GenericObjectPool.Config();

    protected PoolConfig() {
        this.maxIdle(-1);
        this.maxPool(1000);
        this.expiration(30L, TimeUnit.MINUTES);
        this.blockAtCapacity(-1L, TimeUnit.MILLISECONDS);
    }

    public PoolConfig<T, E> maxIdle(int theMaxIdle) {
        this.mConfig.maxIdle = theMaxIdle;
        return this;
    }

    public PoolConfig<T, E> maxPool(int theMax) {
        this.mConfig.maxActive = theMax;
        return this;
    }

    public PoolConfig<T, E> minPool(int theMin) {
        this.mMinPool = theMin;
        return this;
    }

    public PoolConfig<T, E> growAtCapacity() {
        this.maxPool(-1);
        this.mConfig.whenExhaustedAction = (byte)2;
        return this;
    }

    public PoolConfig<T, E> failAtCapacity() {
        this.mConfig.whenExhaustedAction = 0;
        return this;
    }

    public PoolConfig<T, E> blockAtCapacity(long theTime, TimeUnit theUnit) {
        this.mConfig.maxWait = theTime < 0L ? -1L : theUnit.toMillis(theTime);
        this.mConfig.whenExhaustedAction = 1;
        return this;
    }

    public PoolConfig<T, E> noExpiration() {
        this.expiration(-1L, TimeUnit.MILLISECONDS);
        return this;
    }

    public PoolConfig<T, E> expiration(long theTime, TimeUnit theUnit) {
        if (theTime == -1L) {
            this.mConfig.minEvictableIdleTimeMillis = -1L;
            this.mConfig.timeBetweenEvictionRunsMillis = -1L;
        } else {
            this.mConfig.minEvictableIdleTimeMillis = theUnit.toMillis(theTime);
            this.mConfig.timeBetweenEvictionRunsMillis = this.mConfig.minEvictableIdleTimeMillis / 10L;
        }
        return this;
    }

    public abstract Pool<T, E> create();
}

